/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.compact.CompactResult;
import org.apache.flink.table.store.file.data.AppendOnlyCompactManager;
import org.apache.flink.table.store.file.data.AppendOnlyWriter;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.data.DataFilePathFactory;
import org.apache.flink.table.store.file.operation.AbstractFileStoreWrite;
import org.apache.flink.table.store.file.operation.AppendOnlyFileStoreRead;
import org.apache.flink.table.store.file.operation.FileStoreScan;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.RecordReaderIterator;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.file.writer.RecordWriter;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.CloseableIterator;

public class AppendOnlyFileStoreWrite
extends AbstractFileStoreWrite<RowData> {
    private final AppendOnlyFileStoreRead read;
    private final long schemaId;
    private final RowType rowType;
    private final FileFormat fileFormat;
    private final FileStorePathFactory pathFactory;
    private final long targetFileSize;
    private final int minFileNum;
    private final int maxFileNum;
    private final boolean commitForceCompact;

    public AppendOnlyFileStoreWrite(AppendOnlyFileStoreRead read, long schemaId, RowType rowType, FileFormat fileFormat, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, FileStoreScan scan, long targetFileSize, int minFileNum, int maxFileNum, boolean commitForceCompact) {
        super(snapshotManager, scan);
        this.read = read;
        this.schemaId = schemaId;
        this.rowType = rowType;
        this.fileFormat = fileFormat;
        this.pathFactory = pathFactory;
        this.targetFileSize = targetFileSize;
        this.maxFileNum = maxFileNum;
        this.minFileNum = minFileNum;
        this.commitForceCompact = commitForceCompact;
    }

    @Override
    public RecordWriter<RowData> createWriter(BinaryRowData partition, int bucket, ExecutorService compactExecutor) {
        return this.createWriter(partition, bucket, this.scanExistingFileMetas(partition, bucket), compactExecutor);
    }

    @Override
    public RecordWriter<RowData> createEmptyWriter(BinaryRowData partition, int bucket, ExecutorService compactExecutor) {
        return this.createWriter(partition, bucket, Collections.emptyList(), compactExecutor);
    }

    @Override
    public Callable<CompactResult> createCompactWriter(BinaryRowData partition, int bucket, @Nullable List<DataFileMeta> compactFiles) {
        if (compactFiles == null) {
            compactFiles = this.scanExistingFileMetas(partition, bucket);
        }
        return new AppendOnlyCompactManager.IterativeCompactTask(compactFiles, this.targetFileSize, this.minFileNum, this.maxFileNum, this.compactRewriter(partition, bucket), this.pathFactory.createDataFilePathFactory(partition, bucket));
    }

    private RecordWriter<RowData> createWriter(BinaryRowData partition, int bucket, List<DataFileMeta> restoredFiles, ExecutorService compactExecutor) {
        LinkedList<DataFileMeta> restored = new LinkedList<DataFileMeta>(restoredFiles);
        DataFilePathFactory factory = this.pathFactory.createDataFilePathFactory(partition, bucket);
        return new AppendOnlyWriter(this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, restored, new AppendOnlyCompactManager(compactExecutor, restored, this.minFileNum, this.maxFileNum, this.targetFileSize, this.compactRewriter(partition, bucket)), this.commitForceCompact, factory);
    }

    private AppendOnlyCompactManager.CompactRewriter compactRewriter(BinaryRowData partition, int bucket) {
        return toCompact -> {
            if (toCompact.isEmpty()) {
                return Collections.emptyList();
            }
            AppendOnlyWriter.RowRollingWriter rewriter = AppendOnlyWriter.RowRollingWriter.createRollingRowWriter(this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, this.pathFactory.createDataFilePathFactory(partition, bucket), new LongCounter(((DataFileMeta)toCompact.get(0)).minSequenceNumber()));
            return rewriter.write((CloseableIterator<RowData>)new RecordReaderIterator<RowData>(this.read.createReader(new Split(partition, bucket, toCompact, false))));
        };
    }
}

