/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.util.Preconditions;

public class OperatorValidationUtils {
    private OperatorValidationUtils() {
    }

    public static void validateParallelism(int parallelism) {
        OperatorValidationUtils.validateParallelism(parallelism, true);
    }

    public static void validateParallelism(int parallelism, boolean canBeParallel) {
        Preconditions.checkArgument(canBeParallel || parallelism == 1, "The parallelism of non parallel operator must be 1.");
        Preconditions.checkArgument(parallelism > 0 || parallelism == -1, "The parallelism of an operator must be at least 1, or ExecutionConfig.PARALLELISM_DEFAULT (use system default).");
    }

    public static void validateMaxParallelism(int maxParallelism) {
        OperatorValidationUtils.validateMaxParallelism(maxParallelism, Integer.MAX_VALUE, true);
    }

    public static void validateMaxParallelism(int maxParallelism, int upperBound) {
        OperatorValidationUtils.validateMaxParallelism(maxParallelism, upperBound, true);
    }

    public static void validateMaxParallelism(int maxParallelism, boolean canBeParallel) {
        OperatorValidationUtils.validateMaxParallelism(maxParallelism, Integer.MAX_VALUE, canBeParallel);
    }

    public static void validateMaxParallelism(int maxParallelism, int upperBound, boolean canBeParallel) {
        Preconditions.checkArgument(maxParallelism > 0, "The maximum parallelism must be greater than 0.");
        Preconditions.checkArgument(canBeParallel || maxParallelism == 1, "The maximum parallelism of non parallel operator must be 1.");
        Preconditions.checkArgument(maxParallelism > 0 && maxParallelism <= upperBound, "Maximum parallelism must be between 1 and " + upperBound + ". Found: " + maxParallelism);
    }

    public static void validateResources(ResourceSpec resources) {
        Preconditions.checkNotNull(resources, "The resources must be not null.");
    }

    public static void validateMinAndPreferredResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        Preconditions.checkNotNull(minResources, "The min resources must be not null.");
        Preconditions.checkNotNull(preferredResources, "The preferred resources must be not null.");
        Preconditions.checkArgument(minResources.lessThanOrEqual(preferredResources), "The resources must be either both UNKNOWN or both not UNKNOWN. If not UNKNOWN, the preferred resources must be greater than or equal to the min resources.");
    }
}

