/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.shaded.org.apache.avro.file;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class ZstandardLoader {
    ZstandardLoader() {
    }

    static InputStream input(InputStream compressed) throws IOException {
        return new ZstdInputStream(compressed);
    }

    static OutputStream output(OutputStream compressed, int level, boolean checksum) throws IOException {
        int bounded = Math.max(Math.min(level, Zstd.maxCompressionLevel()), Zstd.minCompressionLevel());
        ZstdOutputStream zstdOutputStream = new ZstdOutputStream(compressed, bounded);
        zstdOutputStream.setCloseFrameOnFlush(false);
        zstdOutputStream.setChecksum(checksum);
        return zstdOutputStream;
    }
}

