/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class ArchivedExecution
implements AccessExecution,
Serializable {
    private static final long serialVersionUID = 4817108757483345173L;
    private final ExecutionAttemptID attemptId;
    private final long[] stateTimestamps;
    private final int attemptNumber;
    private final ExecutionState state;
    @Nullable
    private final ErrorInfo failureInfo;
    private final TaskManagerLocation assignedResourceLocation;
    private final AllocationID assignedAllocationID;
    private final StringifiedAccumulatorResult[] userAccumulators;
    private final int parallelSubtaskIndex;
    private final IOMetrics ioMetrics;

    public ArchivedExecution(Execution execution) {
        this(execution.getUserAccumulatorsStringified(), execution.getIOMetrics(), execution.getAttemptId(), execution.getAttemptNumber(), execution.getState(), execution.getFailureInfo().orElse(null), execution.getAssignedResourceLocation(), execution.getAssignedAllocationID(), execution.getVertex().getParallelSubtaskIndex(), execution.getStateTimestamps());
    }

    public ArchivedExecution(StringifiedAccumulatorResult[] userAccumulators, IOMetrics ioMetrics, ExecutionAttemptID attemptId, int attemptNumber, ExecutionState state, @Nullable ErrorInfo failureCause, TaskManagerLocation assignedResourceLocation, AllocationID assignedAllocationID, int parallelSubtaskIndex, long[] stateTimestamps) {
        this.userAccumulators = userAccumulators;
        this.ioMetrics = ioMetrics;
        this.failureInfo = failureCause;
        this.assignedResourceLocation = assignedResourceLocation;
        this.attemptNumber = attemptNumber;
        this.attemptId = attemptId;
        this.state = state;
        this.stateTimestamps = stateTimestamps;
        this.parallelSubtaskIndex = parallelSubtaskIndex;
        this.assignedAllocationID = assignedAllocationID;
    }

    @Override
    public ExecutionAttemptID getAttemptId() {
        return this.attemptId;
    }

    @Override
    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    @Override
    public long[] getStateTimestamps() {
        return this.stateTimestamps;
    }

    @Override
    public ExecutionState getState() {
        return this.state;
    }

    @Override
    public TaskManagerLocation getAssignedResourceLocation() {
        return this.assignedResourceLocation;
    }

    public AllocationID getAssignedAllocationID() {
        return this.assignedAllocationID;
    }

    @Override
    public Optional<ErrorInfo> getFailureInfo() {
        return Optional.ofNullable(this.failureInfo);
    }

    @Override
    public long getStateTimestamp(ExecutionState state) {
        return this.stateTimestamps[state.ordinal()];
    }

    @Override
    public StringifiedAccumulatorResult[] getUserAccumulatorsStringified() {
        return this.userAccumulators;
    }

    @Override
    public int getParallelSubtaskIndex() {
        return this.parallelSubtaskIndex;
    }

    @Override
    public IOMetrics getIOMetrics() {
        return this.ioMetrics;
    }
}

