/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import org.apache.flink.util.ExceptionUtils;

public final class ClassLoaderUtil {
    public static String getUserCodeClassLoaderInfo(ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            URLClassLoader cl = (URLClassLoader)loader;
            try {
                StringBuilder bld = new StringBuilder();
                if (cl == ClassLoader.getSystemClassLoader()) {
                    bld.append("System ClassLoader: ");
                } else {
                    bld.append("URL ClassLoader:");
                }
                for (URL url : cl.getURLs()) {
                    bld.append(ClassLoaderUtil.formatURL(url));
                }
                return bld.toString();
            }
            catch (Throwable t) {
                return "Cannot access classloader info due to an exception.\n" + ExceptionUtils.stringifyException(t);
            }
        }
        if (loader == ClassLoader.getSystemClassLoader()) {
            return "System ClassLoader";
        }
        return "No user code ClassLoader";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatURL(URL url) throws IOException {
        StringBuilder bld = new StringBuilder();
        bld.append("\n    ");
        if (url == null) {
            bld.append("(null)");
        } else if ("file".equals(url.getProtocol())) {
            String filePath = url.getPath();
            File fileFile = new File(filePath);
            bld.append("file: '").append(filePath).append('\'');
            if (fileFile.exists()) {
                if (fileFile.isDirectory()) {
                    bld.append(" (directory)");
                } else {
                    try (JarFile jar = null;){
                        jar = new JarFile(filePath);
                        bld.append(" (valid JAR)");
                    }
                }
            } else {
                bld.append(" (missing)");
            }
        } else {
            bld.append("url: ").append(url);
        }
        return bld.toString();
    }

    public static boolean validateClassLoadable(ClassNotFoundException cnfe, ClassLoader cl) {
        try {
            String className = cnfe.getMessage();
            Class.forName(className, false, cl);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ClassLoaderUtil() {
        throw new RuntimeException();
    }
}

