/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.data.AppendOnlyReader;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.data.DataFilePathFactory;
import org.apache.flink.table.store.file.mergetree.compact.ConcatRecordReader;
import org.apache.flink.table.store.file.operation.FileStoreRead;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.types.logical.RowType;

public class AppendOnlyFileStoreRead
implements FileStoreRead<RowData> {
    private final SchemaManager schemaManager;
    private final long schemaId;
    private final RowType rowType;
    private final FileFormat fileFormat;
    private final FileStorePathFactory pathFactory;
    private int[][] projection;
    private List<Predicate> filters;

    public AppendOnlyFileStoreRead(SchemaManager schemaManager, long schemaId, RowType rowType, FileFormat fileFormat, FileStorePathFactory pathFactory) {
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.rowType = rowType;
        this.fileFormat = fileFormat;
        this.pathFactory = pathFactory;
        this.projection = Projection.range(0, rowType.getFieldCount()).toNestedIndexes();
    }

    public FileStoreRead<RowData> withProjection(int[][] projectedFields) {
        this.projection = projectedFields;
        return this;
    }

    @Override
    public FileStoreRead<RowData> withFilter(Predicate predicate) {
        this.filters = PredicateBuilder.splitAnd(predicate);
        return this;
    }

    @Override
    public RecordReader<RowData> createReader(Split split) throws IOException {
        BulkFormat<RowData, FileSourceSplit> readerFactory = this.fileFormat.createReaderFactory(this.rowType, this.projection, this.filters);
        DataFilePathFactory dataFilePathFactory = this.pathFactory.createDataFilePathFactory(split.partition(), split.bucket());
        ArrayList suppliers = new ArrayList();
        for (DataFileMeta file : split.files()) {
            suppliers.add(() -> new AppendOnlyReader(dataFilePathFactory.toPath(file.fileName()), readerFactory));
        }
        return ConcatRecordReader.create(suppliers);
    }
}

