/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class CommonInputTypeStrategy
implements InputTypeStrategy {
    private static final Signature.Argument COMMON_ARGUMENT = Signature.Argument.of("<COMMON>");
    private final ArgumentCount argumentCount;

    public CommonInputTypeStrategy(ArgumentCount argumentCount) {
        this.argumentCount = argumentCount;
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return this.argumentCount;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        List<LogicalType> argumentTypes = argumentDataTypes.stream().map(DataType::getLogicalType).collect(Collectors.toList());
        if (argumentTypes.stream().anyMatch(CommonInputTypeStrategy::isLegacyType)) {
            return Optional.of(argumentDataTypes);
        }
        Optional<LogicalType> commonType = LogicalTypeMerging.findCommonType(argumentTypes);
        if (!commonType.isPresent()) {
            if (throwOnFailure) {
                throw callContext.newValidationError("Could not find a common type for arguments: %s", argumentDataTypes);
            }
            return Optional.empty();
        }
        return commonType.map(type -> Collections.nCopies(argumentTypes.size(), TypeConversions.fromLogicalToDataType(type)));
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        Optional<Integer> minCount = this.argumentCount.getMinCount();
        Optional<Integer> maxCount = this.argumentCount.getMaxCount();
        int numberOfMandatoryArguments = minCount.orElse(0);
        if (maxCount.isPresent()) {
            return IntStream.range(numberOfMandatoryArguments, maxCount.get() + 1).mapToObj(count -> Signature.of(Collections.nCopies(count, COMMON_ARGUMENT))).collect(Collectors.toList());
        }
        ArrayList<Signature.Argument> arguments = new ArrayList<Signature.Argument>(Collections.nCopies(numberOfMandatoryArguments, COMMON_ARGUMENT));
        arguments.add(Signature.Argument.of("<COMMON>..."));
        return Collections.singletonList(Signature.of(arguments));
    }

    private static boolean isLegacyType(LogicalType type) {
        return type instanceof LegacyTypeInformationType;
    }
}

