/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.EitherTypeInfoFactory;

@TypeInfo(value=EitherTypeInfoFactory.class)
@Public
public abstract class Either<L, R> {
    public static <L, R> Either<L, R> Left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> Right(R value) {
        return new Right(value);
    }

    public abstract L left() throws IllegalStateException;

    public abstract R right() throws IllegalStateException;

    public final boolean isLeft() {
        return this.getClass() == Left.class;
    }

    public final boolean isRight() {
        return this.getClass() == Right.class;
    }

    @Internal
    public static <L, R> Left<L, R> obtainLeft(Either<L, R> input, TypeSerializer<L> leftSerializer) {
        if (input.isLeft()) {
            return (Left)input;
        }
        Right right = (Right)input;
        if (right.left == null) {
            right.left = Left.of(leftSerializer.createInstance());
            right.left.right = right;
        }
        return right.left;
    }

    @Internal
    public static <L, R> Right<L, R> obtainRight(Either<L, R> input, TypeSerializer<R> rightSerializer) {
        if (input.isRight()) {
            return (Right)input;
        }
        Left left = (Left)input;
        if (left.right == null) {
            left.right = Right.of(rightSerializer.createInstance());
            left.right.left = left;
        }
        return left.right;
    }

    public static class Right<L, R>
    extends Either<L, R> {
        private R value;
        private Left<L, R> left;

        public Right(R value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public L left() {
            throw new IllegalStateException("Cannot retrieve Left value on a Right");
        }

        @Override
        public R right() {
            return this.value;
        }

        public void setValue(R value) {
            this.value = value;
        }

        public boolean equals(Object object) {
            if (object instanceof Right) {
                Right other = (Right)object;
                return this.value.equals(other.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Right(" + this.value.toString() + ")";
        }

        public static <L, R> Right<L, R> of(R right) {
            return new Right<L, R>(right);
        }
    }

    public static class Left<L, R>
    extends Either<L, R> {
        private L value;
        private Right<L, R> right;

        public Left(L value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public L left() {
            return this.value;
        }

        @Override
        public R right() {
            throw new IllegalStateException("Cannot retrieve Right value on a Left");
        }

        public void setValue(L value) {
            this.value = value;
        }

        public boolean equals(Object object) {
            if (object instanceof Left) {
                Left other = (Left)object;
                return this.value.equals(other.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Left(" + this.value.toString() + ")";
        }

        public static <L, R> Left<L, R> of(L left) {
            return new Left<L, R>(left);
        }
    }
}

