/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.LocatedFileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalBlockLocation;

@Internal
public class LocalFileStatus
implements LocatedFileStatus {
    private final File file;
    private final Path path;
    private final long len;

    public LocalFileStatus(File f, FileSystem fs) {
        this.file = f;
        this.path = new Path(fs.getUri().getScheme() + ":" + f.toURI().getPath());
        this.len = f.length();
    }

    @Override
    public long getAccessTime() {
        return 0L;
    }

    @Override
    public long getBlockSize() {
        return this.len;
    }

    @Override
    public long getLen() {
        return this.len;
    }

    @Override
    public long getModificationTime() {
        return this.file.lastModified();
    }

    @Override
    public short getReplication() {
        return 1;
    }

    @Override
    public boolean isDir() {
        return this.file.isDirectory();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public BlockLocation[] getBlockLocations() {
        return new BlockLocation[]{new LocalBlockLocation(this.len)};
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return "LocalFileStatus{file=" + this.file + ", path=" + this.path + '}';
    }
}

