/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.checkpoints;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.util.Preconditions;

public class CheckpointConfigInfo
implements ResponseBody {
    public static final String FIELD_NAME_PROCESSING_MODE = "mode";
    public static final String FIELD_NAME_CHECKPOINT_INTERVAL = "interval";
    public static final String FIELD_NAME_CHECKPOINT_TIMEOUT = "timeout";
    public static final String FIELD_NAME_CHECKPOINT_MIN_PAUSE = "min_pause";
    public static final String FIELD_NAME_CHECKPOINT_MAX_CONCURRENT = "max_concurrent";
    public static final String FIELD_NAME_EXTERNALIZED_CHECKPOINT_CONFIG = "externalization";
    public static final String FIELD_NAME_STATE_BACKEND = "state_backend";
    public static final String FIELD_NAME_CHECKPOINT_STORAGE = "checkpoint_storage";
    public static final String FIELD_NAME_UNALIGNED_CHECKPOINTS = "unaligned_checkpoints";
    public static final String FIELD_NAME_TOLERABLE_FAILED_CHECKPOINTS = "tolerable_failed_checkpoints";
    public static final String FIELD_NAME_ALIGNED_CHECKPOINT_TIMEOUT = "aligned_checkpoint_timeout";
    public static final String FIELD_NAME_CHECKPOINTS_AFTER_TASKS_FINISH = "checkpoints_after_tasks_finish";
    @JsonProperty(value="mode")
    private final ProcessingMode processingMode;
    @JsonProperty(value="interval")
    private final long checkpointInterval;
    @JsonProperty(value="timeout")
    private final long checkpointTimeout;
    @JsonProperty(value="min_pause")
    private final long minPauseBetweenCheckpoints;
    @JsonProperty(value="max_concurrent")
    private final long maxConcurrentCheckpoints;
    @JsonProperty(value="externalization")
    private final ExternalizedCheckpointInfo externalizedCheckpointInfo;
    @JsonProperty(value="state_backend")
    private final String stateBackend;
    @JsonProperty(value="checkpoint_storage")
    private final String checkpointStorage;
    @JsonProperty(value="unaligned_checkpoints")
    private final boolean unalignedCheckpoints;
    @JsonProperty(value="tolerable_failed_checkpoints")
    private final int tolerableFailedCheckpoints;
    @JsonProperty(value="aligned_checkpoint_timeout")
    private final long alignedCheckpointTimeout;
    @JsonProperty(value="checkpoints_after_tasks_finish")
    private final boolean checkpointsWithFinishedTasks;

    @JsonCreator
    public CheckpointConfigInfo(@JsonProperty(value="mode") ProcessingMode processingMode, @JsonProperty(value="interval") long checkpointInterval, @JsonProperty(value="timeout") long checkpointTimeout, @JsonProperty(value="min_pause") long minPauseBetweenCheckpoints, @JsonProperty(value="max_concurrent") int maxConcurrentCheckpoints, @JsonProperty(value="externalization") ExternalizedCheckpointInfo externalizedCheckpointInfo, @JsonProperty(value="state_backend") String stateBackend, @JsonProperty(value="checkpoint_storage") String checkpointStorage, @JsonProperty(value="unaligned_checkpoints") boolean unalignedCheckpoints, @JsonProperty(value="tolerable_failed_checkpoints") int tolerableFailedCheckpoints, @JsonProperty(value="aligned_checkpoint_timeout") long alignedCheckpointTimeout, @JsonProperty(value="checkpoints_after_tasks_finish") boolean checkpointsWithFinishedTasks) {
        this.processingMode = Preconditions.checkNotNull(processingMode);
        this.checkpointInterval = checkpointInterval;
        this.checkpointTimeout = checkpointTimeout;
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
        this.externalizedCheckpointInfo = Preconditions.checkNotNull(externalizedCheckpointInfo);
        this.stateBackend = Preconditions.checkNotNull(stateBackend);
        this.checkpointStorage = Preconditions.checkNotNull(checkpointStorage);
        this.unalignedCheckpoints = unalignedCheckpoints;
        this.tolerableFailedCheckpoints = tolerableFailedCheckpoints;
        this.alignedCheckpointTimeout = alignedCheckpointTimeout;
        this.checkpointsWithFinishedTasks = checkpointsWithFinishedTasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointConfigInfo that = (CheckpointConfigInfo)o;
        return this.checkpointInterval == that.checkpointInterval && this.checkpointTimeout == that.checkpointTimeout && this.minPauseBetweenCheckpoints == that.minPauseBetweenCheckpoints && this.maxConcurrentCheckpoints == that.maxConcurrentCheckpoints && this.processingMode == that.processingMode && Objects.equals(this.externalizedCheckpointInfo, that.externalizedCheckpointInfo) && Objects.equals(this.stateBackend, that.stateBackend) && Objects.equals(this.checkpointStorage, that.checkpointStorage) && this.unalignedCheckpoints == that.unalignedCheckpoints && this.tolerableFailedCheckpoints == that.tolerableFailedCheckpoints && this.alignedCheckpointTimeout == that.alignedCheckpointTimeout && this.checkpointsWithFinishedTasks == that.checkpointsWithFinishedTasks;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.processingMode, this.checkpointInterval, this.checkpointTimeout, this.minPauseBetweenCheckpoints, this.maxConcurrentCheckpoints, this.externalizedCheckpointInfo, this.stateBackend, this.checkpointStorage, this.unalignedCheckpoints, this.tolerableFailedCheckpoints, this.alignedCheckpointTimeout, this.checkpointsWithFinishedTasks});
    }

    public static class ProcessingModeDeserializer
    extends StdDeserializer<ProcessingMode> {
        public ProcessingModeDeserializer() {
            super(ProcessingMode.class);
        }

        @Override
        public ProcessingMode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return ProcessingMode.valueOf(jsonParser.getValueAsString().toUpperCase());
        }
    }

    public static class ProcessingModeSerializer
    extends StdSerializer<ProcessingMode> {
        public ProcessingModeSerializer() {
            super(ProcessingMode.class);
        }

        @Override
        public void serialize(ProcessingMode mode, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
            generator.writeString(mode.name().toLowerCase());
        }
    }

    @JsonSerialize(using=ProcessingModeSerializer.class)
    @JsonDeserialize(using=ProcessingModeDeserializer.class)
    public static enum ProcessingMode {
        AT_LEAST_ONCE,
        EXACTLY_ONCE;

    }

    public static final class ExternalizedCheckpointInfo {
        public static final String FIELD_NAME_ENABLED = "enabled";
        public static final String FIELD_NAME_DELETE_ON_CANCELLATION = "delete_on_cancellation";
        @JsonProperty(value="enabled")
        private final boolean enabled;
        @JsonProperty(value="delete_on_cancellation")
        private final boolean deleteOnCancellation;

        @JsonCreator
        public ExternalizedCheckpointInfo(@JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="delete_on_cancellation") boolean deleteOnCancellation) {
            this.enabled = enabled;
            this.deleteOnCancellation = deleteOnCancellation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalizedCheckpointInfo that = (ExternalizedCheckpointInfo)o;
            return this.enabled == that.enabled && this.deleteOnCancellation == that.deleteOnCancellation;
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.deleteOnCancellation);
        }
    }
}

