/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.FunctionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class ConstantFunctionContext
extends FunctionContext {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantFunctionContext.class);
    private static final UnregisteredMetricsGroup metricsGroup = new UnregisteredMetricsGroup();
    private final Map<String, String> jobParameters;

    public ConstantFunctionContext(Configuration configuration) {
        super(null);
        this.jobParameters = configuration.getOptional(PipelineOptions.GLOBAL_JOB_PARAMETERS).map(HashMap::new).orElseGet(HashMap::new);
    }

    @Override
    public MetricGroup getMetricGroup() {
        LOG.warn("Calls to FunctionContext.getMetricGroup will have no effect during constant expression reduction.");
        return metricsGroup;
    }

    @Override
    public File getCachedFile(String name) {
        throw new TableException("Calls to FunctionContext.getCachedFile are not available during constant expression reduction.");
    }

    @Override
    public String getJobParameter(String key, String defaultValue) {
        return this.jobParameters.getOrDefault(key, defaultValue);
    }

    @Override
    public Set<ExternalResourceInfo> getExternalResourceInfos(String resourceName) {
        throw new TableException("Calls to FunctionContext.getExternalResourceInfos are not available during constant expression reduction.");
    }
}

