/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive;

import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveTypeUtils {
    public static TypeInfo logicalTypeToTypeInfo(LogicalType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case BOOLEAN: {
                return TypeInfoFactory.booleanTypeInfo;
            }
            case TINYINT: {
                return TypeInfoFactory.byteTypeInfo;
            }
            case SMALLINT: {
                return TypeInfoFactory.shortTypeInfo;
            }
            case INTEGER: {
                return TypeInfoFactory.intTypeInfo;
            }
            case BIGINT: {
                return TypeInfoFactory.longTypeInfo;
            }
            case FLOAT: {
                return TypeInfoFactory.floatTypeInfo;
            }
            case DOUBLE: {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return TypeInfoFactory.getDecimalTypeInfo((int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case CHAR: {
                CharType charType = (CharType)logicalType;
                return TypeInfoFactory.getCharTypeInfo((int)charType.getLength());
            }
            case VARCHAR: {
                VarCharType varCharType = (VarCharType)logicalType;
                if (varCharType.getLength() == Integer.MAX_VALUE) {
                    return TypeInfoFactory.stringTypeInfo;
                }
                return TypeInfoFactory.getVarcharTypeInfo((int)varCharType.getLength());
            }
            case BINARY: 
            case VARBINARY: {
                return TypeInfoFactory.binaryTypeInfo;
            }
            case DATE: {
                return TypeInfoFactory.dateTypeInfo;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TypeInfoFactory.timestampTypeInfo;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)logicalType;
                return TypeInfoFactory.getListTypeInfo((TypeInfo)HiveTypeUtils.logicalTypeToTypeInfo(arrayType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)logicalType;
                return TypeInfoFactory.getMapTypeInfo((TypeInfo)HiveTypeUtils.logicalTypeToTypeInfo(mapType.getKeyType()), (TypeInfo)HiveTypeUtils.logicalTypeToTypeInfo(mapType.getValueType()));
            }
        }
        throw new UnsupportedOperationException("Unsupported logical type " + logicalType.asSummaryString());
    }
}

