/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.StringUtils;

public class RowDataPartitionComputer {
    protected final String defaultPartValue;
    protected final String[] partitionColumns;
    protected final RowData.FieldGetter[] partitionFieldGetters;

    public RowDataPartitionComputer(String defaultPartValue, RowType rowType, String[] partitionColumns) {
        this.defaultPartValue = defaultPartValue;
        this.partitionColumns = partitionColumns;
        List columnList = rowType.getFieldNames();
        this.partitionFieldGetters = (RowData.FieldGetter[])Arrays.stream(partitionColumns).mapToInt(columnList::indexOf).mapToObj(i -> RowDataUtils.createNullCheckingFieldGetter(rowType.getTypeAt(i), i)).toArray(RowData.FieldGetter[]::new);
    }

    public LinkedHashMap<String, String> generatePartValues(RowData in) {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionFieldGetters.length; ++i) {
            String partitionValue;
            Object field = this.partitionFieldGetters[i].getFieldOrNull(in);
            String string = partitionValue = field != null ? field.toString() : null;
            if (StringUtils.isNullOrWhitespaceOnly((String)partitionValue)) {
                partitionValue = this.defaultPartValue;
            }
            partSpec.put(this.partitionColumns[i], partitionValue);
        }
        return partSpec;
    }
}

