/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.table.store.plugin.ComponentClassLoader;
import org.apache.flink.table.store.utils.LocalFileUtils;
import org.apache.flink.util.IOUtils;

public class PluginLoader {
    public static final String[] PARENT_FIRST_LOGGING_PATTERNS = new String[]{"org.slf4j", "org.apache.log4j", "org.apache.logging", "org.apache.commons.logging", "ch.qos.logback"};
    private static final String[] OWNER_CLASSPATH = (String[])Stream.concat(Arrays.stream(PARENT_FIRST_LOGGING_PATTERNS), Stream.of("org.codehaus.janino", "org.codehaus.commons", "org.apache.commons.lang3")).toArray(String[]::new);
    private static final String[] COMPONENT_CLASSPATH = new String[]{"org.apache.flink"};
    private final ClassLoader submoduleClassLoader;

    public PluginLoader(String jarName) {
        try {
            ClassLoader ownerClassLoader = PluginLoader.class.getClassLoader();
            Path tmpDirectory = Paths.get(ConfigurationUtils.parseTempDirectories((Configuration)new Configuration())[0], new String[0]);
            Files.createDirectories(LocalFileUtils.getTargetPathIfContainsSymbolicPath(tmpDirectory), new FileAttribute[0]);
            Path delegateJar = this.extractResource(jarName, ownerClassLoader, tmpDirectory, String.format("%s could not be found.\nIf you're running a test, please make sure you've built the modules by running\nmvn clean install -DskipTests", jarName));
            this.submoduleClassLoader = new ComponentClassLoader(new URL[]{delegateJar.toUri().toURL()}, ownerClassLoader, OWNER_CLASSPATH, COMPONENT_CLASSPATH);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize the flink-table-store-codegen loader.", e);
        }
    }

    private Path extractResource(String resourceName, ClassLoader flinkClassLoader, Path tmpDirectory, String errorMessage) throws IOException {
        CharSequence[] splitName = resourceName.split("\\.");
        splitName[0] = splitName[0] + "_" + UUID.randomUUID();
        Path tempFile = Files.createFile(tmpDirectory.resolve(String.join((CharSequence)".", splitName)), new FileAttribute[0]);
        InputStream resourceStream = flinkClassLoader.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new RuntimeException(errorMessage);
        }
        IOUtils.copyBytes((InputStream)resourceStream, (OutputStream)Files.newOutputStream(tempFile, new OpenOption[0]));
        return tempFile;
    }

    public <T> T discover(Class<T> clazz) {
        ArrayList results = new ArrayList();
        ServiceLoader.load(clazz, this.submoduleClassLoader).iterator().forEachRemaining(results::add);
        if (results.size() != 1) {
            throw new RuntimeException("Found " + results.size() + " classes implementing " + clazz.getName() + ". They are:\n" + results.stream().map(t -> t.getClass().getName()).collect(Collectors.joining("\n")));
        }
        return (T)results.get(0);
    }

    public <T> T newInstance(String name) {
        try {
            return (T)this.submoduleClassLoader.loadClass(name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

