/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.requests.InitProducerIdResponse;

public class InitProducerIdRequest
extends AbstractRequest {
    private final InitProducerIdRequestData data;

    private InitProducerIdRequest(InitProducerIdRequestData data, short version) {
        super(ApiKeys.INIT_PRODUCER_ID, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        InitProducerIdResponseData response = new InitProducerIdResponseData().setErrorCode(Errors.forException(e).code()).setProducerId(-1L).setProducerEpoch((short)-1).setThrottleTimeMs(0);
        return new InitProducerIdResponse(response);
    }

    public static InitProducerIdRequest parse(ByteBuffer buffer, short version) {
        return new InitProducerIdRequest(new InitProducerIdRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public InitProducerIdRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<InitProducerIdRequest> {
        private final InitProducerIdRequestData data;

        public Builder(InitProducerIdRequestData data) {
            super(ApiKeys.INIT_PRODUCER_ID);
            this.data = data;
        }

        @Override
        public InitProducerIdRequest build(short version) {
            if (this.data.transactionTimeoutMs() <= 0) {
                throw new IllegalArgumentException("transaction timeout value is not positive: " + this.data.transactionTimeoutMs());
            }
            if (this.data.transactionalId() != null && this.data.transactionalId().isEmpty()) {
                throw new IllegalArgumentException("Must set either a null or a non-empty transactional id.");
            }
            return new InitProducerIdRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

