/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.guava30.com.google.common.primitives.Ints;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.operation.ScanKind;
import org.apache.flink.table.store.file.predicate.LeafPredicate;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.predicate.PredicateReplaceVisitor;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.RecordReaderUtils;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.DataTable;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.utils.ProjectedRowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.RowKind;

public class AuditLogTable
implements DataTable {
    public static final String AUDIT_LOG = "audit_log";
    public static final String ROW_KIND = "rowkind";
    public static final PredicateReplaceVisitor PREDICATE_CONVERTER = p -> {
        if (p.index() == 0) {
            return Optional.empty();
        }
        return Optional.of(new LeafPredicate(p.function(), p.type(), p.index() - 1, p.fieldName(), p.literals()));
    };
    private final FileStoreTable dataTable;

    public AuditLogTable(FileStoreTable dataTable) {
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.dataTable.name() + "$" + AUDIT_LOG;
    }

    @Override
    public RowType rowType() {
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        fields.add(new RowType.RowField(ROW_KIND, (LogicalType)new VarCharType(Integer.MAX_VALUE)));
        fields.addAll(this.dataTable.rowType().getFields());
        return new RowType(fields);
    }

    @Override
    public DataTableScan newScan() {
        return new AuditLogScan(this.dataTable.newScan());
    }

    @Override
    public CoreOptions options() {
        return this.dataTable.options();
    }

    @Override
    public Path location() {
        return this.dataTable.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.dataTable.snapshotManager();
    }

    @Override
    public TableRead newRead() {
        return new AuditLogRead(this.dataTable.newRead());
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new AuditLogTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private Optional<Predicate> convert(Predicate predicate) {
        List<Predicate> result = PredicateBuilder.splitAnd(predicate).stream().map(p -> p.visit(PREDICATE_CONVERTER)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(PredicateBuilder.and(result));
    }

    private static class AuditLogRowData
    extends ProjectedRowData {
        private AuditLogRowData(int[] indexMapping, RowData row) {
            super(indexMapping);
            this.replaceRow(row);
        }

        @Override
        public RowKind getRowKind() {
            return RowKind.INSERT;
        }

        @Override
        public void setRowKind(RowKind kind) {
            throw new UnsupportedOperationException("Set row kind is not supported in AuditLogRowData.");
        }

        @Override
        public boolean isNullAt(int pos) {
            if (this.indexMapping[pos] < 0) {
                return false;
            }
            return super.isNullAt(pos);
        }

        @Override
        public StringData getString(int pos) {
            if (this.indexMapping[pos] < 0) {
                return StringData.fromString((String)this.row.getRowKind().shortString());
            }
            return super.getString(pos);
        }
    }

    private class AuditLogRead
    implements TableRead {
        private final TableRead dataRead;
        private int[] readProjection;

        private AuditLogRead(TableRead dataRead) {
            this.dataRead = dataRead;
            this.readProjection = this.defaultProjection();
        }

        private int[] defaultProjection() {
            int dataFieldCount = AuditLogTable.this.dataTable.rowType().getFieldCount();
            int[] projection = new int[dataFieldCount + 1];
            projection[0] = -1;
            for (int i = 0; i < dataFieldCount; ++i) {
                projection[i + 1] = i;
            }
            return projection;
        }

        @Override
        public TableRead withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.dataRead::withFilter);
            return this;
        }

        @Override
        public TableRead withProjection(int[][] projection) {
            ArrayList<int[]> dataProjection = new ArrayList<int[]>();
            ArrayList<Integer> readProjection = new ArrayList<Integer>();
            boolean rowKindAppeared = false;
            for (int i = 0; i < projection.length; ++i) {
                int[] field = projection[i];
                int topField = field[0];
                if (topField == 0) {
                    rowKindAppeared = true;
                    readProjection.add(-1);
                    continue;
                }
                int[] newField = Arrays.copyOf(field, field.length);
                newField[0] = newField[0] - 1;
                dataProjection.add(newField);
                readProjection.add(rowKindAppeared ? i - 1 : i);
            }
            this.readProjection = Ints.toArray(readProjection);
            this.dataRead.withProjection((int[][])dataProjection.toArray((T[])new int[0][]));
            return this;
        }

        @Override
        public RecordReader<RowData> createReader(Split split) throws IOException {
            return RecordReaderUtils.transform(this.dataRead.createReader(split), this::convertRow);
        }

        private RowData convertRow(RowData data) {
            return new AuditLogRowData(this.readProjection, data);
        }
    }

    private class AuditLogScan
    implements DataTableScan {
        private final DataTableScan dataScan;

        private AuditLogScan(DataTableScan dataScan) {
            this.dataScan = dataScan;
        }

        @Override
        public DataTableScan withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.dataScan::withFilter);
            return this;
        }

        @Override
        public DataTableScan withKind(ScanKind kind) {
            this.dataScan.withKind(kind);
            return this;
        }

        @Override
        public DataTableScan withSnapshot(long snapshotId) {
            this.dataScan.withSnapshot(snapshotId);
            return this;
        }

        @Override
        public DataTableScan withLevel(int level) {
            this.dataScan.withLevel(level);
            return this;
        }

        @Override
        public DataTableScan.DataFilePlan plan() {
            return this.dataScan.plan();
        }
    }
}

