/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.client.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Table;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.conf.Configuration;

abstract class ConstraintBuilder<T> {
    protected String catName;
    protected String dbName = "default";
    protected String tableName;
    protected String constraintName;
    List<String> columns = new ArrayList<String>();
    protected boolean enable = true;
    protected boolean validate = false;
    protected boolean rely = false;
    private int nextSeq = 1;
    private T child;

    protected ConstraintBuilder() {
    }

    protected void setChild(T child) {
        this.child = child;
    }

    protected void checkBuildable(String defaultConstraintName, Configuration conf) throws MetaException {
        if (this.tableName == null || this.columns.isEmpty()) {
            throw new MetaException("You must provide table name and columns");
        }
        if (this.constraintName == null) {
            this.constraintName = this.tableName + "_" + defaultConstraintName;
        }
        if (this.catName == null) {
            this.catName = MetaStoreUtils.getDefaultCatalog(conf);
        }
    }

    protected int getNextSeq() {
        return this.nextSeq++;
    }

    public T setCatName(String catName) {
        this.catName = catName;
        return this.child;
    }

    public T setDbName(String dbName) {
        this.dbName = dbName;
        return this.child;
    }

    public T setTableName(String tableName) {
        this.tableName = tableName;
        return this.child;
    }

    public T onTable(Table table) {
        this.catName = table.getCatName();
        this.dbName = table.getDbName();
        this.tableName = table.getTableName();
        return this.child;
    }

    public T addColumn(String columnName) {
        this.columns.add(columnName);
        return this.child;
    }

    public T setConstraintName(String constraintName) {
        this.constraintName = constraintName;
        return this.child;
    }

    public T setEnable(boolean enable) {
        this.enable = enable;
        return this.child;
    }

    public T setValidate(boolean validate) {
        this.validate = validate;
        return this.child;
    }

    public T setRely(boolean rely) {
        this.rely = rely;
        return this.child;
    }
}

