/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public class NormalizedKeyUtil {
    public static void putByteNormalizedKey(byte value, MemorySegment target, int offset, int numBytes) {
        if (numBytes == 1) {
            int highByte = value & 0xFF;
            target.put(offset, (byte)(highByte += 128));
        } else if (numBytes > 0) {
            int highByte = value & 0xFF;
            target.put(offset, (byte)(highByte += 128));
            for (int i = 1; i < numBytes; ++i) {
                target.put(offset + i, (byte)0);
            }
        }
    }

    public static void putCharNormalizedKey(char value, MemorySegment target, int offset, int numBytes) {
        if (numBytes == 2) {
            target.put(offset, (byte)(value >>> 8 & 0xFF));
            target.put(offset + 1, (byte)(value & 0xFF));
        } else if (numBytes > 0) {
            if (numBytes == 1) {
                target.put(offset, (byte)(value >>> 8 & 0xFF));
            } else {
                target.put(offset, (byte)(value >>> 8 & 0xFF));
                target.put(offset + 1, (byte)(value & 0xFF));
                for (int i = 2; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public static void putBooleanNormalizedKey(boolean value, MemorySegment target, int offset, int numBytes) {
        if (numBytes > 0) {
            target.put(offset, (byte)(value ? 1 : 0));
            ++offset;
            while (numBytes > 1) {
                target.put(offset++, (byte)0);
                --numBytes;
            }
        }
    }

    public static void putShortNormalizedKey(short value, MemorySegment target, int offset, int numBytes) {
        if (numBytes == 2) {
            int highByte = value >>> 8 & 0xFF;
            target.put(offset, (byte)(highByte += 128));
            target.put(offset + 1, (byte)(value & 0xFF));
        } else if (numBytes > 0) {
            if (numBytes == 1) {
                int highByte = value >>> 8 & 0xFF;
                target.put(offset, (byte)(highByte += 128));
            } else {
                int highByte = value >>> 8 & 0xFF;
                target.put(offset, (byte)(highByte += 128));
                target.put(offset + 1, (byte)(value & 0xFF));
                for (int i = 2; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public static void putIntNormalizedKey(int iValue, MemorySegment target, int offset, int numBytes) {
        NormalizedKeyUtil.putUnsignedIntegerNormalizedKey(iValue - Integer.MIN_VALUE, target, offset, numBytes);
    }

    public static void putUnsignedIntegerNormalizedKey(int value, MemorySegment target, int offset, int numBytes) {
        block5: {
            block4: {
                if (numBytes != 4) break block4;
                target.putIntBigEndian(offset, value);
                break block5;
            }
            if (numBytes <= 0) break block5;
            if (numBytes < 4) {
                int i = 0;
                while (numBytes > 0) {
                    target.put(offset + i, (byte)(value >>> (3 - i << 3)));
                    --numBytes;
                    ++i;
                }
            } else {
                target.putIntBigEndian(offset, value);
                for (int i = 4; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public static void putLongNormalizedKey(long lValue, MemorySegment target, int offset, int numBytes) {
        NormalizedKeyUtil.putUnsignedLongNormalizedKey(lValue - Long.MIN_VALUE, target, offset, numBytes);
    }

    public static void putUnsignedLongNormalizedKey(long value, MemorySegment target, int offset, int numBytes) {
        block5: {
            block4: {
                if (numBytes != 8) break block4;
                target.putLongBigEndian(offset, value);
                break block5;
            }
            if (numBytes <= 0) break block5;
            if (numBytes < 8) {
                int i = 0;
                while (numBytes > 0) {
                    target.put(offset + i, (byte)(value >>> (7 - i << 3)));
                    --numBytes;
                    ++i;
                }
            } else {
                target.putLongBigEndian(offset, value);
                for (int i = 8; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }
}

