/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.PartitionCommitPolicy;
import org.apache.flink.connector.file.table.PartitionLoader;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.ObjectIdentifier;

@Internal
class FileSystemCommitter {
    private final FileSystemFactory factory;
    private final TableMetaStoreFactory metaStoreFactory;
    private final boolean overwrite;
    private final boolean isToLocal;
    private final Path tmpPath;
    private final int partitionColumnSize;
    private final ObjectIdentifier identifier;
    private final LinkedHashMap<String, String> staticPartitions;
    private final List<PartitionCommitPolicy> policies;

    FileSystemCommitter(FileSystemFactory factory, TableMetaStoreFactory metaStoreFactory, boolean overwrite, Path tmpPath, int partitionColumnSize, boolean isToLocal, ObjectIdentifier identifier, LinkedHashMap<String, String> staticPartitions, List<PartitionCommitPolicy> policies) {
        this.factory = factory;
        this.metaStoreFactory = metaStoreFactory;
        this.overwrite = overwrite;
        this.tmpPath = tmpPath;
        this.partitionColumnSize = partitionColumnSize;
        this.isToLocal = isToLocal;
        this.identifier = identifier;
        this.staticPartitions = staticPartitions;
        this.policies = policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitPartitions() throws Exception {
        FileSystem fs = this.factory.create(this.tmpPath.toUri());
        List<Path> taskPaths = PartitionTempFileManager.listTaskTemporaryPaths(fs, this.tmpPath);
        try (PartitionLoader loader = new PartitionLoader(this.overwrite, fs, this.metaStoreFactory, this.isToLocal, this.identifier, this.policies);){
            if (this.partitionColumnSize > 0) {
                if (taskPaths.isEmpty() && !this.staticPartitions.isEmpty()) {
                    if (this.partitionColumnSize == this.staticPartitions.size()) {
                        loader.loadEmptyPartition(this.staticPartitions);
                    }
                } else {
                    for (Map.Entry<LinkedHashMap<String, String>, List<Path>> entry : PartitionTempFileManager.collectPartSpecToPaths(fs, taskPaths, this.partitionColumnSize).entrySet()) {
                        loader.loadPartition(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                loader.loadNonPartition(taskPaths);
            }
        }
        finally {
            for (Path taskPath : taskPaths) {
                fs.delete(taskPath, true);
            }
        }
    }
}

