/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.execution;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultExecutorServiceLoader
implements PipelineExecutorServiceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExecutorServiceLoader.class);

    @Override
    public PipelineExecutorFactory getExecutorFactory(Configuration configuration) {
        Preconditions.checkNotNull(configuration);
        ServiceLoader<PipelineExecutorFactory> loader = ServiceLoader.load(PipelineExecutorFactory.class);
        ArrayList<PipelineExecutorFactory> compatibleFactories = new ArrayList<PipelineExecutorFactory>();
        Iterator<PipelineExecutorFactory> factories = loader.iterator();
        while (factories.hasNext()) {
            try {
                PipelineExecutorFactory factory = factories.next();
                if (factory == null || !factory.isCompatibleWith(configuration)) continue;
                compatibleFactories.add(factory);
            }
            catch (Throwable e2) {
                if (e2.getCause() instanceof NoClassDefFoundError) {
                    LOG.info("Could not load factory due to missing dependencies.");
                    continue;
                }
                throw e2;
            }
        }
        if (compatibleFactories.size() > 1) {
            String configStr = configuration.toMap().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("\n"));
            throw new IllegalStateException("Multiple compatible client factories found for:\n" + configStr + ".");
        }
        if (compatibleFactories.isEmpty()) {
            throw new IllegalStateException("No ExecutorFactory found to execute the application.");
        }
        return (PipelineExecutorFactory)compatibleFactories.get(0);
    }

    @Override
    public Stream<String> getExecutorNames() {
        ServiceLoader<PipelineExecutorFactory> loader = ServiceLoader.load(PipelineExecutorFactory.class);
        return StreamSupport.stream(loader.spliterator(), false).map(PipelineExecutorFactory::getName);
    }
}

