/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public final class ResourceID
implements ResourceIDRetrievable,
Serializable {
    private static final long serialVersionUID = 42L;
    private final String resourceId;
    private final String metadata;

    public ResourceID(String resourceId) {
        this(resourceId, "");
    }

    public ResourceID(String resourceId, String metadata) {
        Preconditions.checkNotNull(resourceId, "The identifier must not be null");
        Preconditions.checkNotNull(metadata, "The metadata must not be null");
        this.resourceId = resourceId;
        this.metadata = metadata;
    }

    public final String getResourceIdString() {
        return this.resourceId;
    }

    public final String getStringWithMetadata() {
        return StringUtils.isNullOrWhitespaceOnly(this.metadata) ? this.resourceId : String.format("%s(%s)", this.resourceId, this.metadata);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.resourceId.equals(((ResourceID)o).resourceId);
    }

    public final int hashCode() {
        return this.resourceId.hashCode();
    }

    public String toString() {
        return this.resourceId;
    }

    @Override
    public ResourceID getResourceID() {
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public static ResourceID generate() {
        return new ResourceID(new AbstractID().toString());
    }
}

