/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.SimpleTransformationTranslator;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.transformations.UnionTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class UnionTransformationTranslator<OUT>
extends SimpleTransformationTranslator<OUT, UnionTransformation<OUT>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(UnionTransformation<OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(UnionTransformation<OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    private Collection<Integer> translateInternal(UnionTransformation<OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull(context);
        ArrayList<Integer> resultIds = new ArrayList<Integer>();
        for (Transformation<?> input : transformation.getInputs()) {
            resultIds.addAll(context.getStreamNodeIds(input));
        }
        return resultIds;
    }
}

