/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file;

import java.util.Comparator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.AbstractFileStore;
import org.apache.flink.table.store.file.operation.AppendOnlyFileStoreRead;
import org.apache.flink.table.store.file.operation.AppendOnlyFileStoreScan;
import org.apache.flink.table.store.file.operation.AppendOnlyFileStoreWrite;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.types.logical.RowType;

public class AppendOnlyFileStore
extends AbstractFileStore<RowData> {
    private final RowType bucketKeyType;
    private final RowType rowType;

    public AppendOnlyFileStore(SchemaManager schemaManager, long schemaId, CoreOptions options, RowType partitionType, RowType bucketKeyType, RowType rowType) {
        super(schemaManager, schemaId, options, partitionType);
        this.bucketKeyType = bucketKeyType;
        this.rowType = rowType;
    }

    @Override
    public AppendOnlyFileStoreScan newScan() {
        return this.newScan(false);
    }

    public AppendOnlyFileStoreRead newRead() {
        return new AppendOnlyFileStoreRead(this.schemaManager, this.schemaId, this.rowType, this.options.fileFormat(), this.pathFactory());
    }

    public AppendOnlyFileStoreWrite newWrite(String commitUser) {
        return new AppendOnlyFileStoreWrite(this.newRead(), this.schemaId, commitUser, this.rowType, this.pathFactory(), this.snapshotManager(), this.newScan(true), this.options);
    }

    private AppendOnlyFileStoreScan newScan(boolean checkNumOfBuckets) {
        return new AppendOnlyFileStoreScan(this.partitionType, this.bucketKeyType.getFieldCount() == 0 ? this.rowType : this.bucketKeyType, this.rowType, this.snapshotManager(), this.schemaManager, this.schemaId, this.manifestFileFactory(), this.manifestListFactory(), this.options.bucket(), checkNumOfBuckets);
    }

    @Override
    public Comparator<RowData> newKeyComparator() {
        return null;
    }
}

