/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact.aggregate;

import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldAggregator;
import org.apache.flink.table.types.logical.LogicalType;

public class FieldListaggAgg
extends FieldAggregator {
    public static final String DELIMITER = ",";

    public FieldListaggAgg(LogicalType logicalType) {
        super(logicalType);
    }

    @Override
    Object agg(Object accumulator, Object inputField) {
        Object concatenate;
        if (inputField == null || accumulator == null) {
            concatenate = inputField == null ? accumulator : inputField;
        } else {
            switch (this.fieldType.getTypeRoot()) {
                case VARCHAR: {
                    StringData mergeFieldSD = (StringData)accumulator;
                    StringData inFieldSD = (StringData)inputField;
                    concatenate = BinaryStringDataUtil.concat((BinaryStringData)mergeFieldSD, new BinaryStringData(DELIMITER), (BinaryStringData)inFieldSD);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return concatenate;
    }
}

