/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source.snapshot;

import java.util.Collections;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.snapshot.StartingScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousFromTimestampStartingScanner
implements StartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousFromTimestampStartingScanner.class);
    private final long startupMillis;

    public ContinuousFromTimestampStartingScanner(long startupMillis) {
        this.startupMillis = startupMillis;
    }

    @Override
    public DataTableScan.DataFilePlan getPlan(SnapshotManager snapshotManager, DataTableScan scan) {
        Long startingSnapshotId = snapshotManager.earlierThanTimeMills(this.startupMillis);
        if (startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Waiting for snapshot generation.");
            return null;
        }
        return new DataTableScan.DataFilePlan(startingSnapshotId, Collections.emptyList());
    }
}

