/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.runtime.io.compression.BlockCompressor;
import org.apache.flink.runtime.io.compression.BufferCompressionException;
import org.apache.flink.runtime.io.compression.CompressorUtils;
import org.apache.flink.shaded.io.airlift.compress.Compressor;

public class AirBlockCompressor
implements BlockCompressor {
    private final Compressor internalCompressor;

    public AirBlockCompressor(Compressor internalCompressor) {
        this.internalCompressor = internalCompressor;
    }

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return 8 + this.internalCompressor.maxCompressedLength(srcSize);
    }

    @Override
    public int compress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) throws BufferCompressionException {
        try {
            if (dst.remaining() < dstOff + this.getMaxCompressedSize(srcLen)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int prevSrcOff = src.position() + srcOff;
            int prevDstOff = dst.position() + dstOff;
            src.position(prevSrcOff);
            dst.position(prevDstOff + 8);
            this.internalCompressor.compress(src, dst);
            int compressedLength = dst.position() - prevDstOff - 8;
            dst.position(prevDstOff);
            dst.order(ByteOrder.LITTLE_ENDIAN);
            dst.putInt(compressedLength);
            dst.putInt(srcLen);
            dst.position(prevDstOff + compressedLength + 8);
            return 8 + compressedLength;
        }
        catch (Exception e) {
            throw new BufferCompressionException(e);
        }
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws BufferCompressionException {
        try {
            if (dst.length < dstOff + this.getMaxCompressedSize(srcLen)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int compressedLength = this.internalCompressor.compress(src, srcOff, srcLen, dst, dstOff + 8, this.internalCompressor.maxCompressedLength(srcLen));
            CompressorUtils.writeIntLE(compressedLength, dst, dstOff);
            CompressorUtils.writeIntLE(srcLen, dst, dstOff + 4);
            return 8 + compressedLength;
        }
        catch (Exception e) {
            throw new BufferCompressionException(e);
        }
    }
}

