/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;

class DefaultExecutionVertex
implements SchedulingExecutionVertex {
    private final ExecutionVertexID executionVertexId;
    private final List<DefaultResultPartition> producedResults;
    private final Supplier<ExecutionState> stateSupplier;
    private final List<ConsumedPartitionGroup> consumedPartitionGroups;
    private final Function<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionRetriever;

    DefaultExecutionVertex(ExecutionVertexID executionVertexId, List<DefaultResultPartition> producedPartitions, Supplier<ExecutionState> stateSupplier, List<ConsumedPartitionGroup> consumedPartitionGroups, Function<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionRetriever) {
        this.executionVertexId = Preconditions.checkNotNull(executionVertexId);
        this.stateSupplier = Preconditions.checkNotNull(stateSupplier);
        this.producedResults = Preconditions.checkNotNull(producedPartitions);
        this.consumedPartitionGroups = Preconditions.checkNotNull(consumedPartitionGroups);
        this.resultPartitionRetriever = Preconditions.checkNotNull(resultPartitionRetriever);
    }

    @Override
    public ExecutionVertexID getId() {
        return this.executionVertexId;
    }

    @Override
    public ExecutionState getState() {
        return this.stateSupplier.get();
    }

    @Override
    public Iterable<DefaultResultPartition> getConsumedResults() {
        return IterableUtils.flatMap(this.consumedPartitionGroups, this.resultPartitionRetriever);
    }

    @Override
    public List<ConsumedPartitionGroup> getConsumedPartitionGroups() {
        return this.consumedPartitionGroups;
    }

    @Override
    public Iterable<DefaultResultPartition> getProducedResults() {
        return this.producedResults;
    }
}

