/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.hadoop.HadoopUserUtils;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosLoginProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosLoginProvider.class);
    private final String principal;
    private final String keytab;
    private final boolean useTicketCache;

    public KerberosLoginProvider(Configuration configuration) {
        Preconditions.checkNotNull(configuration, "Flink configuration must not be null");
        SecurityConfiguration securityConfiguration = new SecurityConfiguration(configuration);
        this.principal = securityConfiguration.getPrincipal();
        this.keytab = securityConfiguration.getKeytab();
        this.useTicketCache = securityConfiguration.useTicketCache();
    }

    public boolean isLoginPossible() throws IOException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        if (this.principal != null) {
            LOG.debug("Login from keytab is possible");
            return true;
        }
        if (!HadoopUserUtils.isProxyUser(currentUser)) {
            if (this.useTicketCache && currentUser.hasKerberosCredentials()) {
                LOG.debug("Login from ticket cache is possible");
                return true;
            }
        } else {
            this.throwProxyUserNotSupported();
        }
        LOG.debug("Login is NOT possible");
        return false;
    }

    public UserGroupInformation doLogin() throws IOException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        if (this.principal != null) {
            LOG.info("Attempting to login to KDC using principal: {} keytab: {}", (Object)this.principal, (Object)this.keytab);
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal, (String)this.keytab);
            LOG.info("Successfully logged into KDC");
            return ugi;
        }
        if (!HadoopUserUtils.isProxyUser(currentUser)) {
            LOG.info("Attempting to load user's ticket cache");
            String ccache = System.getenv("KRB5CCNAME");
            String user = Optional.ofNullable(System.getenv("KRB5PRINCIPAL")).orElse(currentUser.getUserName());
            UserGroupInformation ugi = UserGroupInformation.getUGIFromTicketCache((String)ccache, (String)user);
            LOG.info("Loaded user's ticket cache successfully");
            return ugi;
        }
        this.throwProxyUserNotSupported();
        return currentUser;
    }

    private void throwProxyUserNotSupported() {
        throw new UnsupportedOperationException("Proxy user is not supported");
    }
}

