/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;

public class NettyShuffleDescriptor
implements ShuffleDescriptor {
    private static final long serialVersionUID = 852181945034989215L;
    private final ResourceID producerLocation;
    private final PartitionConnectionInfo partitionConnectionInfo;
    private final ResultPartitionID resultPartitionID;

    public NettyShuffleDescriptor(ResourceID producerLocation, PartitionConnectionInfo partitionConnectionInfo, ResultPartitionID resultPartitionID) {
        this.producerLocation = producerLocation;
        this.partitionConnectionInfo = partitionConnectionInfo;
        this.resultPartitionID = resultPartitionID;
    }

    public ConnectionID getConnectionId() {
        return this.partitionConnectionInfo.getConnectionId();
    }

    @Override
    public ResultPartitionID getResultPartitionID() {
        return this.resultPartitionID;
    }

    @Override
    public Optional<ResourceID> storesLocalResourcesOn() {
        return Optional.of(this.producerLocation);
    }

    public boolean isLocalTo(ResourceID consumerLocation) {
        return this.producerLocation.equals(consumerLocation);
    }

    public static enum LocalExecutionPartitionConnectionInfo implements PartitionConnectionInfo
    {
        INSTANCE;


        @Override
        public ConnectionID getConnectionId() {
            throw new UnsupportedOperationException("Local execution does not support shuffle connection.");
        }
    }

    public static class NetworkPartitionConnectionInfo
    implements PartitionConnectionInfo {
        private static final long serialVersionUID = 5992534320110743746L;
        private final ConnectionID connectionID;

        @VisibleForTesting
        public NetworkPartitionConnectionInfo(ConnectionID connectionID) {
            this.connectionID = connectionID;
        }

        @Override
        public ConnectionID getConnectionId() {
            return this.connectionID;
        }

        static NetworkPartitionConnectionInfo fromProducerDescriptor(ProducerDescriptor producerDescriptor, int connectionIndex) {
            InetSocketAddress address = new InetSocketAddress(producerDescriptor.getAddress(), producerDescriptor.getDataPort());
            return new NetworkPartitionConnectionInfo(new ConnectionID(address, connectionIndex));
        }
    }

    @FunctionalInterface
    public static interface PartitionConnectionInfo
    extends Serializable {
        public ConnectionID getConnectionId();
    }
}

