/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.catalog;

import java.util.List;
import java.util.Optional;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.store.file.catalog.CatalogLock;
import org.apache.flink.table.store.file.schema.SchemaChange;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.schema.UpdateSchema;
import org.apache.flink.table.store.table.Table;

public interface Catalog
extends AutoCloseable {
    public static final String DEFAULT_DATABASE = "default";
    public static final String SYSTEM_TABLE_SPLITTER = "$";

    public Optional<CatalogLock.Factory> lockFactory();

    public List<String> listDatabases();

    public boolean databaseExists(String var1);

    public void createDatabase(String var1, boolean var2) throws DatabaseAlreadyExistException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws DatabaseNotExistException, DatabaseNotEmptyException;

    public List<String> listTables(String var1) throws DatabaseNotExistException;

    public Path getTableLocation(ObjectPath var1);

    public TableSchema getTableSchema(ObjectPath var1) throws TableNotExistException;

    public Table getTable(ObjectPath var1) throws TableNotExistException;

    public boolean tableExists(ObjectPath var1);

    public void dropTable(ObjectPath var1, boolean var2) throws TableNotExistException;

    public void createTable(ObjectPath var1, UpdateSchema var2, boolean var3) throws TableAlreadyExistException, DatabaseNotExistException;

    public void alterTable(ObjectPath var1, List<SchemaChange> var2, boolean var3) throws TableNotExistException;

    public static class TableNotExistException
    extends Exception {
        private static final String MSG = "Table %s does not exist.";
        private final ObjectPath tablePath;

        public TableNotExistException(ObjectPath tablePath) {
            this(tablePath, null);
        }

        public TableNotExistException(ObjectPath tablePath, Throwable cause) {
            super(String.format(MSG, tablePath.getFullName()), cause);
            this.tablePath = tablePath;
        }

        public ObjectPath tablePath() {
            return this.tablePath;
        }
    }

    public static class TableAlreadyExistException
    extends Exception {
        private static final String MSG = "Table %s already exists.";
        private final ObjectPath tablePath;

        public TableAlreadyExistException(ObjectPath tablePath) {
            this(tablePath, null);
        }

        public TableAlreadyExistException(ObjectPath tablePath, Throwable cause) {
            super(String.format(MSG, tablePath.getFullName()), cause);
            this.tablePath = tablePath;
        }

        public ObjectPath tablePath() {
            return this.tablePath;
        }
    }

    public static class DatabaseNotExistException
    extends Exception {
        private static final String MSG = "Database %s does not exist.";
        private final String database;

        public DatabaseNotExistException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseNotExistException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }

    public static class DatabaseAlreadyExistException
    extends Exception {
        private static final String MSG = "Database %s already exists.";
        private final String database;

        public DatabaseAlreadyExistException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseAlreadyExistException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }

    public static class DatabaseNotEmptyException
    extends Exception {
        private static final String MSG = "Database %s is not empty.";
        private final String database;

        public DatabaseNotEmptyException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseNotEmptyException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }
}

