/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

@Internal
public class Plan
implements Visitable<Operator<?>>,
Pipeline {
    protected final List<GenericDataSinkBase<?>> sinks = new ArrayList(4);
    protected String jobName;
    protected int defaultParallelism = -1;
    protected HashMap<String, DistributedCache.DistributedCacheEntry> cacheFile = new HashMap();
    protected ExecutionConfig executionConfig;
    private JobID jobId;

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks, String jobName) {
        this(sinks, jobName, -1);
    }

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks, String jobName, int defaultParallelism) {
        this.sinks.addAll(sinks);
        this.jobName = jobName;
        this.defaultParallelism = defaultParallelism;
    }

    public Plan(GenericDataSinkBase<?> sink, String jobName) {
        this(sink, jobName, -1);
    }

    public Plan(GenericDataSinkBase<?> sink, String jobName, int defaultParallelism) {
        this(Collections.singletonList(sink), jobName, defaultParallelism);
    }

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks) {
        this(sinks, -1);
    }

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks, int defaultParallelism) {
        this(sinks, "Flink Job at " + Calendar.getInstance().getTime(), defaultParallelism);
    }

    public Plan(GenericDataSinkBase<?> sink) {
        this(sink, -1);
    }

    public Plan(GenericDataSinkBase<?> sink, int defaultParallelism) {
        this(sink, "Flink Job at " + Calendar.getInstance().getTime(), defaultParallelism);
    }

    public void addDataSink(GenericDataSinkBase<?> sink) {
        Preconditions.checkNotNull(sink, "The data sink must not be null.");
        if (!this.sinks.contains(sink)) {
            this.sinks.add(sink);
        }
    }

    public Collection<? extends GenericDataSinkBase<?>> getDataSinks() {
        return this.sinks;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        Preconditions.checkNotNull(jobName, "The job name must not be null.");
        this.jobName = jobName;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public void setJobId(JobID jobId) {
        this.jobId = jobId;
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    public void setDefaultParallelism(int defaultParallelism) {
        Preconditions.checkArgument(defaultParallelism >= 1 || defaultParallelism == -1, "The default parallelism must be positive, or ExecutionConfig.PARALLELISM_DEFAULT if the system should use the globally configured default.");
        this.defaultParallelism = defaultParallelism;
    }

    public String getPostPassClassName() {
        return "org.apache.flink.optimizer.postpass.JavaApiPostPass";
    }

    public ExecutionConfig getExecutionConfig() {
        if (this.executionConfig == null) {
            throw new RuntimeException("Execution config has not been set properly for this plan");
        }
        return this.executionConfig;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
    }

    @Override
    public void accept(Visitor<Operator<?>> visitor) {
        for (GenericDataSinkBase<?> sink : this.sinks) {
            sink.accept(visitor);
        }
    }

    public void registerCachedFile(String name, DistributedCache.DistributedCacheEntry entry) throws IOException {
        if (this.cacheFile.containsKey(name)) {
            throw new IOException("cache file " + name + "already exists!");
        }
        this.cacheFile.put(name, entry);
    }

    public Set<Map.Entry<String, DistributedCache.DistributedCacheEntry>> getCachedFiles() {
        return this.cacheFile.entrySet();
    }

    public int getMaximumParallelism() {
        MaxDopVisitor visitor = new MaxDopVisitor();
        this.accept(visitor);
        return Math.max(visitor.maxDop, this.defaultParallelism);
    }

    private static final class MaxDopVisitor
    implements Visitor<Operator<?>> {
        private final Set<Operator> visitedOperators = new HashSet<Operator>();
        private int maxDop = -1;

        private MaxDopVisitor() {
        }

        @Override
        public boolean preVisit(Operator<?> visitable) {
            if (!this.visitedOperators.add(visitable)) {
                return false;
            }
            this.maxDop = Math.max(this.maxDop, visitable.getParallelism());
            return true;
        }

        @Override
        public void postVisit(Operator<?> visitable) {
        }
    }
}

