/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.runtime.io.compression.BlockDecompressor;
import org.apache.flink.runtime.io.compression.BufferDecompressionException;
import org.apache.flink.runtime.io.compression.CompressorUtils;
import org.apache.flink.shaded.io.airlift.compress.Decompressor;
import org.apache.flink.shaded.io.airlift.compress.MalformedInputException;

public class AirBlockDecompressor
implements BlockDecompressor {
    private final Decompressor internalDecompressor;

    public AirBlockDecompressor(Decompressor internalDecompressor) {
        this.internalDecompressor = internalDecompressor;
    }

    @Override
    public int decompress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) throws BufferDecompressionException {
        int prevSrcOff = src.position() + srcOff;
        int prevDstOff = dst.position() + dstOff;
        src.position(prevSrcOff);
        dst.position(prevDstOff);
        src.order(ByteOrder.LITTLE_ENDIAN);
        int compressedLen = src.getInt();
        int originalLen = src.getInt();
        CompressorUtils.validateLength(compressedLen, originalLen);
        if (dst.capacity() - prevDstOff < originalLen) {
            throw new BufferDecompressionException("Buffer length too small");
        }
        if (src.limit() - prevSrcOff - 8 < compressedLen) {
            throw new BufferDecompressionException("Source data is not integral for decompression.");
        }
        src.limit(prevSrcOff + compressedLen + 8);
        try {
            this.internalDecompressor.decompress(src, dst);
            if (originalLen != dst.position() - prevDstOff) {
                throw new BufferDecompressionException("Input is corrupted, unexpected original length.");
            }
        }
        catch (MalformedInputException e) {
            throw new BufferDecompressionException("Input is corrupted", e);
        }
        return originalLen;
    }

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws BufferDecompressionException {
        int compressedLen = CompressorUtils.readIntLE(src, srcOff);
        int originalLen = CompressorUtils.readIntLE(src, srcOff + 4);
        CompressorUtils.validateLength(compressedLen, originalLen);
        if (dst.length - dstOff < originalLen) {
            throw new BufferDecompressionException("Buffer length too small");
        }
        if (src.length - srcOff - 8 < compressedLen) {
            throw new BufferDecompressionException("Source data is not integral for decompression.");
        }
        try {
            int decompressedLen = this.internalDecompressor.decompress(src, srcOff + 8, compressedLen, dst, dstOff, originalLen);
            if (originalLen != decompressedLen) {
                throw new BufferDecompressionException("Input is corrupted");
            }
        }
        catch (MalformedInputException e) {
            throw new BufferDecompressionException("Input is corrupted", e);
        }
        return originalLen;
    }
}

