/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;

@Internal
public class FeedbackTransformation<T>
extends Transformation<T> {
    private final Transformation<T> input;
    private final List<Transformation<T>> feedbackEdges;
    private final Long waitTime;

    public FeedbackTransformation(Transformation<T> input, Long waitTime) {
        super("Feedback", input.getOutputType(), input.getParallelism());
        this.input = input;
        this.waitTime = waitTime;
        this.feedbackEdges = Lists.newArrayList();
    }

    public void addFeedbackEdge(Transformation<T> transform) {
        if (transform.getParallelism() != this.getParallelism()) {
            throw new UnsupportedOperationException("Parallelism of the feedback stream must match the parallelism of the original stream. Parallelism of original stream: " + this.getParallelism() + "; parallelism of feedback stream: " + transform.getParallelism() + ". Parallelism can be modified using DataStream#setParallelism() method");
        }
        this.feedbackEdges.add(transform);
    }

    public List<Transformation<T>> getFeedbackEdges() {
        return this.feedbackEdges;
    }

    public Long getWaitTime() {
        return this.waitTime;
    }

    @Override
    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList<Transformation<?>> result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    @Override
    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }
}

