/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table;

import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateFilter;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.RecordReaderIterator;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.sink.BucketComputer;
import org.apache.flink.table.store.table.sink.TableCommit;
import org.apache.flink.table.store.table.sink.TableWrite;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.types.RowKind;

public interface SupportsWrite
extends Table {
    public BucketComputer bucketComputer();

    public TableWrite newWrite(String var1);

    public TableCommit newCommit(String var1);

    default public void deleteWhere(String commitUser, List<Predicate> filters, Lock.Factory lockFactory) {
        List<Split> splits = this.newScan().withFilter(filters).plan().splits();
        try (RecordReader<RowData> reader = this.newRead().withFilter(filters).createReader(splits);
             TableWrite write = this.newWrite(commitUser);
             TableCommit commit = this.newCommit(commitUser).withLock(lockFactory.create());){
            RecordReaderIterator<RowData> iterator = new RecordReaderIterator<RowData>(reader);
            PredicateFilter filter = new PredicateFilter(this.rowType(), filters);
            while (iterator.hasNext()) {
                RowData row = iterator.next();
                if (!filter.test(row)) continue;
                row.setRowKind(RowKind.DELETE);
                write.write(row);
            }
            commit.commit(0L, write.prepareCommit(true, 0L));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

