/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.hybrid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.base.source.hybrid.SwitchedSources;
import org.apache.flink.core.io.SimpleVersionedSerializer;

public class HybridSourceSplit
implements SourceSplit {
    private final byte[] wrappedSplitBytes;
    private final int wrappedSplitSerializerVersion;
    private final int sourceIndex;
    private final String splitId;

    public HybridSourceSplit(int sourceIndex, byte[] wrappedSplit, int serializerVersion, String splitId) {
        this.sourceIndex = sourceIndex;
        this.wrappedSplitBytes = wrappedSplit;
        this.wrappedSplitSerializerVersion = serializerVersion;
        this.splitId = splitId;
    }

    public int sourceIndex() {
        return this.sourceIndex;
    }

    public byte[] wrappedSplitBytes() {
        return this.wrappedSplitBytes;
    }

    public int wrappedSplitSerializerVersion() {
        return this.wrappedSplitSerializerVersion;
    }

    @Override
    public String splitId() {
        return this.splitId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HybridSourceSplit that = (HybridSourceSplit)o;
        return this.sourceIndex == that.sourceIndex && Arrays.equals(this.wrappedSplitBytes, that.wrappedSplitBytes);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.wrappedSplitBytes), this.sourceIndex);
    }

    public String toString() {
        return "HybridSourceSplit{sourceIndex=" + this.sourceIndex + ", splitId=" + this.splitId + '}';
    }

    public static List<HybridSourceSplit> wrapSplits(List<? extends SourceSplit> state, int readerIndex, SwitchedSources switchedSources) {
        ArrayList<HybridSourceSplit> wrappedSplits = new ArrayList<HybridSourceSplit>(state.size());
        for (SourceSplit sourceSplit : state) {
            wrappedSplits.add(HybridSourceSplit.wrapSplit(sourceSplit, readerIndex, switchedSources));
        }
        return wrappedSplits;
    }

    public static HybridSourceSplit wrapSplit(SourceSplit split, int sourceIndex, SwitchedSources switchedSources) {
        try {
            SimpleVersionedSerializer<SourceSplit> serializer = switchedSources.serializerOf(sourceIndex);
            byte[] serialized = serializer.serialize(split);
            return new HybridSourceSplit(sourceIndex, serialized, serializer.getVersion(), split.splitId());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<SourceSplit> unwrapSplits(List<HybridSourceSplit> splits, SwitchedSources switchedSources) {
        ArrayList<SourceSplit> unwrappedSplits = new ArrayList<SourceSplit>(splits.size());
        for (HybridSourceSplit split : splits) {
            unwrappedSplits.add(HybridSourceSplit.unwrapSplit(split, switchedSources));
        }
        return unwrappedSplits;
    }

    public static SourceSplit unwrapSplit(HybridSourceSplit split, SwitchedSources switchedSources) {
        try {
            return switchedSources.serializerOf(split.sourceIndex()).deserialize(split.wrappedSplitSerializerVersion(), split.wrappedSplitBytes());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

