/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.table.store.file.io.DataFileMeta;

public class NewFilesIncrement {
    private final List<DataFileMeta> newFiles;
    private final List<DataFileMeta> changelogFiles;

    public NewFilesIncrement(List<DataFileMeta> newFiles, List<DataFileMeta> changelogFiles) {
        this.newFiles = newFiles;
        this.changelogFiles = changelogFiles;
    }

    public static NewFilesIncrement emptyIncrement() {
        return new NewFilesIncrement(Collections.emptyList(), Collections.emptyList());
    }

    public List<DataFileMeta> newFiles() {
        return this.newFiles;
    }

    public List<DataFileMeta> changelogFiles() {
        return this.changelogFiles;
    }

    public boolean isEmpty() {
        return this.newFiles.isEmpty() && this.changelogFiles.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewFilesIncrement that = (NewFilesIncrement)o;
        return Objects.equals(this.newFiles, that.newFiles) && Objects.equals(this.changelogFiles, that.changelogFiles);
    }

    public int hashCode() {
        return Objects.hash(this.newFiles, this.changelogFiles);
    }

    public String toString() {
        return String.format("NewFilesIncrement {newFiles = [\n%s\n], changelogFiles = [\n%s\n]}", this.newFiles.stream().map(DataFileMeta::fileName).collect(Collectors.joining(",\n")), this.changelogFiles.stream().map(DataFileMeta::fileName).collect(Collectors.joining(",\n")));
    }
}

