/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import java.util.Comparator;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.compact.CompactResult;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.KeyValueFileReaderFactory;
import org.apache.flink.table.store.file.io.KeyValueFileWriterFactory;
import org.apache.flink.table.store.file.io.RollingFileWriter;
import org.apache.flink.table.store.file.mergetree.MergeTreeReaders;
import org.apache.flink.table.store.file.mergetree.SortedRun;
import org.apache.flink.table.store.file.mergetree.compact.AbstractCompactRewriter;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunctionFactory;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.RecordReaderIterator;

public class MergeTreeCompactRewriter
extends AbstractCompactRewriter {
    protected final KeyValueFileReaderFactory readerFactory;
    protected final KeyValueFileWriterFactory writerFactory;
    protected final Comparator<RowData> keyComparator;
    protected final MergeFunctionFactory<KeyValue> mfFactory;

    public MergeTreeCompactRewriter(KeyValueFileReaderFactory readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<RowData> keyComparator, MergeFunctionFactory<KeyValue> mfFactory) {
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.keyComparator = keyComparator;
        this.mfFactory = mfFactory;
    }

    @Override
    public CompactResult rewrite(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        return this.rewriteCompaction(outputLevel, dropDelete, sections);
    }

    protected CompactResult rewriteCompaction(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        RollingFileWriter<KeyValue, DataFileMeta> writer = this.writerFactory.createRollingMergeTreeFileWriter(outputLevel);
        RecordReader<KeyValue> sectionsReader = MergeTreeReaders.readerForMergeTree(sections, dropDelete, this.readerFactory, this.keyComparator, this.mfFactory.create());
        writer.write((KeyValue)((Object)new RecordReaderIterator<KeyValue>(sectionsReader)));
        writer.close();
        return new CompactResult(MergeTreeCompactRewriter.extractFilesFromSections(sections), (List<DataFileMeta>)writer.result());
    }
}

