/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestFile;
import org.apache.flink.table.store.file.manifest.ManifestList;
import org.apache.flink.table.store.file.operation.AbstractFileStoreScan;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.KeyValueFieldsExtractor;
import org.apache.flink.table.store.file.schema.RowDataType;
import org.apache.flink.table.store.file.schema.SchemaEvolutionUtil;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.types.logical.RowType;

public class KeyValueFileStoreScan
extends AbstractFileStoreScan {
    private final ConcurrentMap<Long, FieldStatsArraySerializer> schemaKeyStatsConverters;
    private final KeyValueFieldsExtractor keyValueFieldsExtractor;
    private final RowType keyType;
    private Predicate keyFilter;

    public KeyValueFileStoreScan(RowType partitionType, RowType bucketKeyType, RowType keyType, SnapshotManager snapshotManager, SchemaManager schemaManager, long schemaId, KeyValueFieldsExtractor keyValueFieldsExtractor, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets) {
        super(partitionType, bucketKeyType, snapshotManager, schemaManager, schemaId, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets);
        this.keyValueFieldsExtractor = keyValueFieldsExtractor;
        this.schemaKeyStatsConverters = new ConcurrentHashMap<Long, FieldStatsArraySerializer>();
        this.keyType = keyType;
    }

    public KeyValueFileStoreScan withKeyFilter(Predicate predicate) {
        this.keyFilter = predicate;
        List<Predicate> bucketFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), this.keyType.getFieldNames(), this.bucketKeyType.getFieldNames());
        if (bucketFilters.size() > 0) {
            this.withBucketKeyFilter(PredicateBuilder.and(bucketFilters));
        }
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        return this.keyFilter == null || this.keyFilter.test(entry.file().rowCount(), entry.file().keyStats().fields(this.getFieldStatsArraySerializer(entry.file().schemaId()), entry.file().rowCount()));
    }

    private FieldStatsArraySerializer getFieldStatsArraySerializer(long id) {
        return this.schemaKeyStatsConverters.computeIfAbsent(id, key -> {
            TableSchema tableSchema = this.scanTableSchema();
            TableSchema schema = this.scanTableSchema((long)key);
            List<DataField> keyFields = this.keyValueFieldsExtractor.keyFields(schema);
            return new FieldStatsArraySerializer(RowDataType.toRowType(false, keyFields), tableSchema.id() == key.longValue() ? null : SchemaEvolutionUtil.createIndexMapping(this.keyValueFieldsExtractor.keyFields(tableSchema), keyFields));
        });
    }
}

