/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;

@Internal
class IfNullTypeStrategy
implements TypeStrategy {
    IfNullTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType inputDataType = argumentDataTypes.get(0);
        DataType nullReplacementDataType = argumentDataTypes.get(1);
        if (!inputDataType.getLogicalType().isNullable()) {
            return Optional.of(inputDataType);
        }
        return Optional.of(nullReplacementDataType);
    }
}

