/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio.exporter;

import com.healthmarketscience.rmiio.RemoteInputStreamServer;
import com.healthmarketscience.rmiio.RemoteOutputStreamServer;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteStreamServerInvokerHelper {
    public static final int OUT_USING_COMPRESSION_METHOD = 1301;
    public static final int OUT_CLOSE_METHOD = 1302;
    public static final int OUT_FLUSH_METHOD = 1303;
    public static final int OUT_WRITE_PACKET_METHOD = 1304;
    public static final int IN_USING_COMPRESSION_METHOD = 1351;
    public static final int IN_AVAILABLE_METHOD = 1352;
    public static final int IN_CLOSE_METHOD = 1353;
    public static final int IN_READ_PACKET_METHOD = 1354;
    public static final int IN_SKIP_METHOD = 1355;

    private RemoteStreamServerInvokerHelper() {
    }

    public static Object invoke(RemoteOutputStreamServer server, int methodCode, Object[] parameters) throws IOException {
        switch (methodCode) {
            case 1304: {
                byte[] packet = (byte[])parameters[0];
                int packetId = (Integer)parameters[1];
                server.writePacket(packet, packetId);
                return null;
            }
            case 1301: {
                return server.usingGZIPCompression();
            }
            case 1303: {
                server.flush();
                return null;
            }
            case 1302: {
                boolean success = (Boolean)parameters[0];
                server.close(success);
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown invocation on " + RemoteStreamServerInvokerHelper.invocationToString(server, methodCode, parameters));
    }

    public static Object invoke(RemoteInputStreamServer server, int methodCode, Object[] parameters) throws IOException {
        switch (methodCode) {
            case 1354: {
                int packetId = (Integer)parameters[0];
                return server.readPacket(packetId);
            }
            case 1352: {
                return server.available();
            }
            case 1355: {
                long numBytes = (Long)parameters[0];
                int skipId = (Integer)parameters[1];
                return server.skip(numBytes, skipId);
            }
            case 1351: {
                return server.usingGZIPCompression();
            }
            case 1353: {
                boolean success = (Boolean)parameters[0];
                server.close(success);
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown invocation on " + RemoteStreamServerInvokerHelper.invocationToString(server, methodCode, parameters));
    }

    private static final String invocationToString(RemoteStreamServer<?, ?> server, int methodCode, Object[] parameters) {
        return "server " + server + ": " + methodCode + " " + Arrays.deepToString(parameters);
    }
}

