/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

public class Probe {
    MulticastSocket mcast_sock;
    volatile boolean running = true;
    final Set<String> senders = new HashSet<String>();

    public void start(List<InetAddress> addrs, InetAddress bind_addr, int port, int ttl, final long timeout, List<String> query, String match, boolean weed_out_duplicates, String passcode) throws Exception {
        for (InetAddress addr : addrs) {
            boolean unicast_dest;
            boolean bl = unicast_dest = addr != null && !addr.isMulticastAddress();
            if (unicast_dest) {
                Collection<InetAddress> targets = Probe.getPhysicalAddresses(addr, bind_addr, port, timeout);
                if (targets.isEmpty()) {
                    System.err.println("Found no valid hosts - terminating");
                    return;
                }
                for (InetAddress target : targets) {
                    this.sendRequest(target, bind_addr, port, ttl, query, passcode);
                }
                continue;
            }
            this.sendRequest(addr, bind_addr, port, ttl, query, passcode);
        }
        new Thread(){

            @Override
            public void run() {
                Util.sleep(timeout);
                Probe.this.mcast_sock.close();
                Probe.this.running = false;
            }
        }.start();
        int matched = 0;
        int not_matched = 0;
        int count = 0;
        while (this.running) {
            byte[] buf = new byte[70000];
            DatagramPacket rsp = new DatagramPacket(buf, 0, buf.length);
            try {
                this.mcast_sock.receive(rsp);
            }
            catch (Throwable t) {
                System.out.println("\n");
                break;
            }
            byte[] data = rsp.getData();
            String response = new String(data, 0, rsp.getLength());
            if (weed_out_duplicates && this.checkDuplicateResponse(response)) continue;
            ++count;
            if (Probe.matches(response, match)) {
                ++matched;
                System.out.println("\n#" + count + " (" + rsp.getLength() + " bytes):\n" + response);
                continue;
            }
            ++not_matched;
        }
        System.out.println("\n" + count + " responses (" + matched + " matches, " + not_matched + " non matches)");
    }

    protected static Collection<InetAddress> getPhysicalAddresses(InetAddress addr, InetAddress bind_addr, int port, final long timeout) throws Exception {
        final DatagramSocket sock = new DatagramSocket(new InetSocketAddress(bind_addr, 0));
        byte[] payload = "addrs".getBytes();
        DatagramPacket probe = new DatagramPacket(payload, 0, payload.length, addr, port);
        sock.send(probe);
        new Thread(){

            @Override
            public void run() {
                Util.sleep(timeout);
                sock.close();
            }
        }.start();
        ArrayList<InetAddress> retval = new ArrayList<InetAddress>();
        long end_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end_time) {
            byte[] buf = new byte[70000];
            DatagramPacket rsp = new DatagramPacket(buf, 0, buf.length);
            try {
                sock.receive(rsp);
            }
            catch (Throwable t) {
                break;
            }
            byte[] data = rsp.getData();
            String response = new String(data, 0, rsp.getLength());
            if (response == null || !response.startsWith("addrs=")) continue;
            response = response.substring("addrs=".length()).trim();
            List<String> rsps = Util.parseStringList(response, ",");
            for (String tmp : rsps) {
                int index = tmp.indexOf(58);
                if (index != -1) {
                    tmp = tmp.substring(0, index);
                }
                retval.add(InetAddress.getByName(tmp));
            }
            return retval;
        }
        return retval;
    }

    protected void sendRequest(InetAddress addr, InetAddress bind_addr, int port, int ttl, List<String> query, String passcode) throws Exception {
        byte[] queryPayload;
        if (this.mcast_sock == null) {
            this.mcast_sock = new MulticastSocket();
            this.mcast_sock.setTimeToLive(ttl);
            if (bind_addr != null) {
                this.mcast_sock.setInterface(bind_addr);
            }
        }
        StringBuilder request = new StringBuilder();
        byte[] authenticationDigest = null;
        if (passcode != null) {
            long t1 = new Date().getTime();
            double q1 = Math.random();
            authenticationDigest = Util.createAuthenticationDigest(passcode, t1, q1);
        }
        for (int i = 0; i < query.size(); ++i) {
            request.append(query.get(i)).append(" ");
        }
        byte[] payload = queryPayload = request.toString().getBytes();
        if (authenticationDigest != null) {
            payload = new byte[authenticationDigest.length + queryPayload.length];
            System.arraycopy(authenticationDigest, 0, payload, 0, authenticationDigest.length);
            System.arraycopy(queryPayload, 0, payload, authenticationDigest.length, queryPayload.length);
        }
        DatagramPacket probe = new DatagramPacket(payload, 0, payload.length, addr, port);
        this.mcast_sock.send(probe);
        System.out.println("\n-- sending probe on " + addr + ':' + port + '\n');
    }

    private boolean checkDuplicateResponse(String response) {
        int index = response.indexOf("local_addr");
        if (index != -1) {
            String addr = Probe.parseAddress(response.substring(index + 1 + "local_addr".length()));
            return !this.senders.add(addr);
        }
        return false;
    }

    private static String parseAddress(String response) {
        StringTokenizer st = new StringTokenizer(response);
        return st.nextToken();
    }

    private static boolean matches(String response, String match) {
        if (response == null) {
            return false;
        }
        if (match == null) {
            return true;
        }
        int index = response.indexOf(match);
        return index > -1;
    }

    public static void main(String[] args) {
        InetAddress bind_addr = null;
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        int port = 0;
        int ttl = 32;
        long timeout = 500L;
        String DEFAULT_DIAG_ADDR = "224.0.75.75";
        String DEFAULT_DIAG_ADDR_IPv6 = "ff0e::0:75:75";
        int DEFAULT_DIAG_PORT = 7500;
        ArrayList<String> query = new ArrayList<String>();
        String match = null;
        boolean weed_out_duplicates = false;
        String passcode = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("-addr".equals(args[i])) {
                    addrs.add(InetAddress.getByName(args[++i]));
                    continue;
                }
                if ("-bind_addr".equals(args[i])) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-port".equals(args[i])) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-ttl".equals(args[i])) {
                    ttl = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-timeout".equals(args[i])) {
                    timeout = Long.parseLong(args[++i]);
                    continue;
                }
                if ("-match".equals(args[i])) {
                    match = args[++i];
                    continue;
                }
                if ("-weed_out_duplicates".equals(args[i])) {
                    weed_out_duplicates = true;
                    continue;
                }
                if ("-passcode".equals(args[i])) {
                    passcode = args[++i];
                    continue;
                }
                if ("-cluster".equals(args[i])) {
                    String cluster = args[++i];
                    query.add("cluster=" + cluster);
                    continue;
                }
                if ("-help".equals(args[i]) || "-h".equals(args[i]) || "--help".equals(args[i])) {
                    Probe.help();
                    return;
                }
                query.add(args[i]);
            }
            Probe p = new Probe();
            if (addrs.isEmpty()) {
                StackType stack_type = Util.getIpStackType();
                boolean ipv6 = stack_type == StackType.IPv6;
                InetAddress addr = ipv6 ? InetAddress.getByName("ff0e::0:75:75") : InetAddress.getByName("224.0.75.75");
                addrs.add(addr);
            }
            if (port == 0) {
                port = 7500;
            }
            p.start(addrs, bind_addr, port, ttl, timeout, query, match, weed_out_duplicates, passcode);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void help() {
        System.out.println("Probe [-help] [-addr <addr>] [-bind_addr <addr>] [-port <port>] [-ttl <ttl>] [-timeout <timeout>] [-passcode <code>] [-weed_out_duplicates] [-cluster regexp-pattern] [-match pattern] [key[=value]]*\n\nExamples:\nprobe.sh keys // dumps all valid commands\nprobe.sh jmx=NAKACK // dumps JMX info about all NAKACK protocols\nprobe.sh op=STABLE.runMessageGarbageCollection // invokes the method in all STABLE protocols\nprobe.sh jmx=UDP.oob,thread_pool // dumps all attrs of UDP starting with oob* or thread_pool*\nprobe.sh jmx=FLUSH.bypass=true\n");
    }
}

