/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.TimeScheduler;

public class ResponseCollectorTask<T>
extends ResponseCollector<T> {
    protected Consumer<ResponseCollectorTask<T>> periodic_task;
    protected Consumer<ResponseCollectorTask<T>> finalizer_task;
    protected Future<?> runner;
    protected final Runnable stub = new Runnable(){

        @Override
        public void run() {
            ResponseCollectorTask.this.periodic_task.accept(ResponseCollectorTask.this);
        }
    };

    public ResponseCollectorTask() {
    }

    public ResponseCollectorTask(Collection<Address> members) {
        super(members);
    }

    public ResponseCollectorTask(Address ... members) {
        super(members);
    }

    public ResponseCollectorTask<T> setPeriodicTask(Consumer<ResponseCollectorTask<T>> pt) {
        this.periodic_task = pt;
        return this;
    }

    public ResponseCollectorTask<T> setFinalizerTask(Consumer<ResponseCollectorTask<T>> r) {
        this.finalizer_task = r;
        return this;
    }

    public synchronized boolean isDone() {
        return this.runner == null || this.runner.isDone();
    }

    public synchronized ResponseCollectorTask<T> start(TimeScheduler timer, long initial_delay, long interval) {
        if (this.hasAllResponses()) {
            return this;
        }
        if (this.periodic_task != null && (this.runner == null || this.runner.isDone())) {
            this.runner = timer.scheduleAtFixedRate(this.stub, initial_delay, interval, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public synchronized ResponseCollectorTask<T> stop() {
        if (this.runner != null) {
            this.runner.cancel(true);
            this.runner = null;
            if (this.finalizer_task != null) {
                this.finalizer_task.accept(this);
            }
        }
        return this;
    }

    @Override
    public boolean add(Address member, T data) {
        boolean retval = super.add(member, data);
        if (retval && this.hasAllResponses()) {
            this.stop();
        }
        return retval;
    }

    @Override
    public boolean retainAll(List<Address> members) {
        boolean retval = super.retainAll(members);
        if (retval && this.hasAllResponses()) {
            this.stop();
        }
        return retval;
    }

    public static interface Consumer<C> {
        public void accept(C var1);
    }
}

