/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.execute;

import java.util.Map;
import java.util.Set;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.FunctionExecutionService;
import org.apache.geode.internal.cache.execute.InternalFunctionExecutionServiceImpl;

public class FunctionService {
    @MakeNotStatic(value="The FunctionService requires a cache. We need to have an instance per cache.")
    private static final FunctionService INSTANCE = new FunctionService(new InternalFunctionExecutionServiceImpl());
    private final FunctionExecutionService functionExecutionService;

    protected FunctionService(FunctionExecutionService functionExecutionService) {
        this.functionExecutionService = functionExecutionService;
    }

    public static Execution onRegion(Region region) {
        return FunctionService.getFunctionExecutionService().onRegion(region);
    }

    public static Execution onServer(Pool pool) {
        return FunctionService.getFunctionExecutionService().onServer(pool);
    }

    public static Execution onServers(Pool pool) {
        return FunctionService.getFunctionExecutionService().onServers(pool);
    }

    public static Execution onServer(RegionService regionService) {
        return FunctionService.getFunctionExecutionService().onServer(regionService);
    }

    public static Execution onServers(RegionService regionService) {
        return FunctionService.getFunctionExecutionService().onServers(regionService);
    }

    public static Execution onMember(DistributedMember distributedMember) {
        return FunctionService.getFunctionExecutionService().onMember(distributedMember);
    }

    public static Execution onMembers(String ... groups) {
        return FunctionService.getFunctionExecutionService().onMembers(groups);
    }

    public static Execution onMembers(Set<DistributedMember> distributedMembers) {
        return FunctionService.getFunctionExecutionService().onMembers(distributedMembers);
    }

    public static Execution onMember(String ... groups) {
        return FunctionService.getFunctionExecutionService().onMember(groups);
    }

    public static Function getFunction(String functionId) {
        return FunctionService.getFunctionExecutionService().getFunction(functionId);
    }

    public static void registerFunction(Function function) {
        FunctionService.getFunctionExecutionService().registerFunction(function);
    }

    public static void unregisterFunction(String functionId) {
        FunctionService.getFunctionExecutionService().unregisterFunction(functionId);
    }

    public static boolean isRegistered(String functionId) {
        return FunctionService.getFunctionExecutionService().isRegistered(functionId);
    }

    public static Map<String, Function> getRegisteredFunctions() {
        return FunctionService.getFunctionExecutionService().getRegisteredFunctions();
    }

    private static FunctionExecutionService getFunctionExecutionService() {
        return FunctionService.INSTANCE.functionExecutionService;
    }
}

