/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.AbstractGroupOrRangeJunction;
import org.apache.geode.cache.query.internal.CompiledComparison;
import org.apache.geode.cache.query.internal.CompiledJunction;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.SelectResultsComparator;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.parse.OQLLexerTokenTypes;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;

public class CompositeGroupJunction
extends AbstractCompiledValue
implements Filter,
OQLLexerTokenTypes {
    private int operator = 0;
    private List filterableCC = new ArrayList();
    private List groupJunctions = null;
    private boolean completeExpansion = false;
    private List indpndntItrs = null;
    private List iterOperands = null;
    private RuntimeIterator[] indpndnts = null;

    CompositeGroupJunction(int operator, CompiledValue filterableCondn) {
        this.operator = operator;
        this.filterableCC.add(filterableCondn);
        this.indpndntItrs = new ArrayList();
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        if (this.groupJunctions != null) {
            children.addAll(this.groupJunctions);
        }
        children.addAll(this.filterableCC);
        return children;
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        throw new AssertionError((Object)"Should not have come here");
    }

    @Override
    public int getType() {
        return -10;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.operator == 91) {
            return this.evaluateAndJunction(context);
        }
        return this.evaluateOrJunction(context);
    }

    void addFilterableCompositeCondition(CompiledValue cv) {
        this.filterableCC.add(cv);
    }

    void addIndependentIterators(RuntimeIterator itr) {
        this.indpndntItrs.add(itr);
    }

    void addGroupOrRangeJunction(AbstractGroupOrRangeJunction gj) {
        if (this.groupJunctions == null) {
            this.groupJunctions = new ArrayList();
        }
        this.groupJunctions.add(gj);
    }

    void addIterOperands(List iterOps) {
        if (this.iterOperands == null) {
            this.iterOperands = new ArrayList();
        }
        this.iterOperands.addAll(iterOps);
    }

    void setCompleteExpansionOn() {
        this.completeExpansion = true;
        if (this.groupJunctions != null && this.groupJunctions.size() == 1) {
            AbstractGroupOrRangeJunction gj = (AbstractGroupOrRangeJunction)this.groupJunctions.get(0);
            gj.setCompleteExpansionOn();
        }
    }

    void setArrayOfIndependentItrs() {
        this.indpndnts = new RuntimeIterator[this.indpndntItrs.size()];
        this.indpndnts = this.indpndntItrs.toArray(this.indpndnts);
        this.indpndntItrs = null;
    }

    void mergeFilterableCCsAndIndependentItrs(CompositeGroupJunction temp) {
        this.filterableCC.addAll(temp.filterableCC);
        this.indpndntItrs.addAll(temp.indpndntItrs);
    }

    private SelectResults evaluateAndJunction(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        CompiledValue iterOp = null;
        SelectResults intermediateResults = null;
        if (this.iterOperands != null && !this.iterOperands.isEmpty()) {
            int len = this.iterOperands.size();
            if (len == 1) {
                iterOp = (CompiledValue)this.iterOperands.get(0);
            } else {
                CompiledValue[] newOperands = new CompiledValue[len];
                newOperands = this.iterOperands.toArray(newOperands);
                iterOp = new CompiledJunction(newOperands, this.operator);
            }
        }
        TreeSet<SelectResults> intersectionSet = new TreeSet<SelectResults>(new SelectResultsComparator());
        boolean delayIterOpEval = this.groupJunctions != null && this.groupJunctions.size() != 0;
        Iterator itr = this.filterableCC.iterator();
        int filterableCCSize = this.filterableCC.size();
        if (filterableCCSize > 1) {
            for (int i = 0; i < filterableCCSize - 1; ++i) {
                CompiledValue cc = (CompiledValue)itr.next();
                intermediateResults = ((Filter)((Object)cc)).filterEvaluate(context, intermediateResults, false, null, null, false, true, false);
                if (!intermediateResults.isEmpty()) continue;
                StructType structType = QueryUtils.createStructTypeForRuntimeIterators(this.completeExpansion ? context.getCurrentIterators() : QueryUtils.getDependentItrChainForIndpndntItrs(this.indpndnts, context));
                return QueryUtils.createStructCollection(context, structType);
            }
        }
        CompiledValue cc = (CompiledValue)itr.next();
        intermediateResults = ((Filter)((Object)cc)).filterEvaluate(context, intermediateResults, this.completeExpansion, delayIterOpEval ? null : iterOp, this.indpndnts, false, true, false);
        intersectionSet.add(intermediateResults);
        intermediateResults = null;
        if (iterOp != null && !delayIterOpEval) {
            iterOp = null;
        }
        Support.Assert(iterOp == null || this.groupJunctions != null, "The Iter operand can be not null only if there exists atleast one group junction");
        if (this.groupJunctions != null) {
            int len = this.groupJunctions.size();
            if (len > 1) {
                Collection[] results = new SelectResults[len];
                List finalList = null;
                finalList = this.completeExpansion ? context.getCurrentIterators() : QueryUtils.getDependentItrChainForIndpndntItrs(this.indpndnts, context);
                LinkedList expansionList = new LinkedList(finalList);
                RuntimeIterator[][] itrsForResultFields = new RuntimeIterator[len][];
                AbstractGroupOrRangeJunction gj = null;
                Iterator junctionItr = this.groupJunctions.iterator();
                List grpItrs = null;
                int j = 0;
                RuntimeIterator tempItr = null;
                while (junctionItr.hasNext()) {
                    gj = (AbstractGroupOrRangeJunction)junctionItr.next();
                    SelectResults filterResults = gj.filterEvaluate(context, null);
                    Support.Assert(filterResults != null, "FilterResults cannot be null here");
                    if (filterResults.isEmpty()) {
                        SelectResults empty = null;
                        if (finalList.size() == 1) {
                            ObjectType type = ((RuntimeIterator)finalList.iterator().next()).getElementType();
                            empty = type instanceof StructType ? QueryUtils.createStructCollection(context, (StructTypeImpl)type) : QueryUtils.createResultCollection(context, type);
                        } else {
                            StructType strucType = QueryUtils.createStructTypeForRuntimeIterators(finalList);
                            empty = QueryUtils.createStructCollection(context, strucType);
                        }
                        return empty;
                    }
                    results[j] = filterResults;
                    grpItrs = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(gj.getIndependentIteratorForGroup()[0]);
                    itrsForResultFields[j] = new RuntimeIterator[grpItrs.size()];
                    Iterator grpItr = grpItrs.iterator();
                    int k = 0;
                    while (grpItr.hasNext()) {
                        tempItr = (RuntimeIterator)grpItr.next();
                        itrsForResultFields[j][k++] = tempItr;
                        expansionList.remove(tempItr);
                    }
                    ++j;
                }
                QueryObserver observer = QueryObserverHolder.getInstance();
                observer.beforeCartesianOfGroupJunctionsInCompositeGroupJunctionOfType_AND(results);
                SelectResults grpCartRs = QueryUtils.cartesian((SelectResults[])results, itrsForResultFields, expansionList, finalList, context, iterOp);
                observer.afterCartesianOfGroupJunctionsInCompositeGroupJunctionOfType_AND();
                Support.Assert(grpCartRs != null, "ResultsSet obtained was NULL in CompositeGroupJunction");
                intersectionSet.add(grpCartRs);
            } else {
                AbstractGroupOrRangeJunction newGJ = (AbstractGroupOrRangeJunction)this.groupJunctions.get(0);
                if (!this.completeExpansion) {
                    newGJ = newGJ.recreateFromOld(this.completeExpansion, this.indpndnts, iterOp);
                } else if (iterOp != null) {
                    newGJ = newGJ.recreateFromOld(this.completeExpansion, newGJ.getIndependentIteratorForGroup(), iterOp);
                }
                SelectResults rs = newGJ.filterEvaluate(context, null);
                if (rs.isEmpty()) {
                    return rs;
                }
                intersectionSet.add(rs);
            }
        }
        for (SelectResults sr : intersectionSet) {
            intermediateResults = intermediateResults == null ? sr : QueryUtils.intersection(intermediateResults, sr, context);
        }
        return intermediateResults;
    }

    private SelectResults evaluateOrJunction(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults intermediateResults = null;
        Iterator itr = this.filterableCC.iterator();
        Support.Assert(this.iterOperands == null || this.iterOperands.isEmpty(), "The iter operands shoudl not have been present for OR junction");
        while (itr.hasNext()) {
            CompiledComparison cc = (CompiledComparison)itr.next();
            SelectResults sr = ((Filter)cc).filterEvaluate(context, null, this.completeExpansion, null, this.indpndnts, false, true, false);
            intermediateResults = intermediateResults == null ? sr : QueryUtils.union(intermediateResults, sr, context);
        }
        if (this.groupJunctions != null) {
            int len = this.groupJunctions.size();
            if (len > 1) {
                SelectResults[] grpResults = new SelectResults[1];
                List finalList = null;
                finalList = this.completeExpansion ? context.getCurrentIterators() : QueryUtils.getDependentItrChainForIndpndntItrs(this.indpndnts, context);
                RuntimeIterator[][] itrsForResultFields = new RuntimeIterator[1][];
                AbstractGroupOrRangeJunction gj = null;
                Iterator junctionItr = this.groupJunctions.iterator();
                List grpItrs = null;
                RuntimeIterator tempItr = null;
                while (junctionItr.hasNext()) {
                    LinkedList expansionList = new LinkedList(finalList);
                    gj = (AbstractGroupOrRangeJunction)junctionItr.next();
                    grpResults[0] = gj.filterEvaluate(context, null);
                    grpItrs = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(gj.getIndependentIteratorForGroup()[0]);
                    itrsForResultFields[0] = new RuntimeIterator[grpItrs.size()];
                    Iterator grpItr = grpItrs.iterator();
                    int k = 0;
                    while (grpItr.hasNext()) {
                        tempItr = (RuntimeIterator)grpItr.next();
                        itrsForResultFields[0][k++] = tempItr;
                        expansionList.remove(tempItr);
                    }
                    SelectResults expandedResult = QueryUtils.cartesian(grpResults, itrsForResultFields, expansionList, finalList, context, null);
                    intermediateResults = intermediateResults == null ? expandedResult : QueryUtils.union(expandedResult, intermediateResults, context);
                }
            } else {
                AbstractGroupOrRangeJunction newGJ = (AbstractGroupOrRangeJunction)this.groupJunctions.get(0);
                if (!this.completeExpansion) {
                    newGJ = newGJ.recreateFromOld(this.completeExpansion, this.indpndnts, null);
                }
                SelectResults rs = newGJ.filterEvaluate(context, null);
                intermediateResults = intermediateResults == null ? rs : QueryUtils.union(rs, intermediateResults, context);
            }
        }
        return intermediateResults;
    }

    @Override
    public int getOperator() {
        return this.operator;
    }

    RuntimeIterator[] getIndependentIteratorsOfCJ() {
        return this.indpndnts;
    }

    List getFilterableCCList() {
        return Collections.unmodifiableList(this.filterableCC);
    }

    List getGroupJunctionList() {
        return this.groupJunctions != null ? Collections.unmodifiableList(this.groupJunctions) : null;
    }

    List getIterOperands() {
        return this.iterOperands != null ? Collections.unmodifiableList(this.iterOperands) : null;
    }

    boolean getExpansionFlag() {
        return this.completeExpansion;
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return 1;
    }
}

