/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.PooledExecutorWithDMStats;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;

public class SerialQueuedExecutorWithDMStats
extends ThreadPoolExecutor {
    final PoolStatHelper stats;
    private final ThreadsMonitoring threadMonitoring;

    public SerialQueuedExecutorWithDMStats(BlockingQueue q, PoolStatHelper stats, ThreadFactory tf, ThreadsMonitoring tMonitoring) {
        super(1, 1, 60L, TimeUnit.SECONDS, q, tf, new PooledExecutorWithDMStats.BlockHandler());
        this.stats = stats;
        this.threadMonitoring = tMonitoring;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.stats != null) {
            this.stats.startJob();
        }
        if (this.threadMonitoring != null) {
            this.threadMonitoring.startMonitor(ThreadsMonitoring.Mode.SerialQueuedExecutor);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable ex) {
        if (this.stats != null) {
            this.stats.endJob();
        }
        if (this.threadMonitoring != null) {
            this.threadMonitoring.endMonitor();
        }
    }
}

