/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.internal.Strings;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskInitFile;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.PersistentOplogSet;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.cache.versions.DiskRegionVersionVector;
import org.apache.geode.internal.cache.versions.RegionVersionHolder;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.concurrent.ConcurrentMapWithReusableEntries;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDiskRegion
implements DiskRegionView {
    private static final Logger logger = LogService.getLogger();
    private final DiskStoreImpl ds;
    private final long id;
    private long clearOplogEntryId = 0L;
    private RegionVersionVector clearRVV;
    private byte lruAlgorithm;
    private byte lruAction;
    private int lruLimit;
    private int concurrencyLevel = 16;
    private int initialCapacity = 16;
    private float loadFactor = 0.75f;
    private boolean statisticsEnabled;
    private boolean isBucket;
    private boolean backup;
    private final EnumSet<DiskInitFile.DiskRegionFlag> flags;
    private boolean isRecreated;
    private boolean configChanged;
    private boolean aboutToDestroy;
    private boolean aboutToDestroyDataStorage;
    private String partitionName;
    private int startingBucketId;
    private String compressorClassName;
    private Compressor compressor;
    private boolean offHeap;
    private RegionVersionVector versionVector;
    private volatile boolean rvvTrusted = true;
    private PersistentMemberID myInitializingId = null;
    private PersistentMemberID myInitializedId = null;
    private final CopyOnWriteHashSet<PersistentMemberID> onlineMembers;
    private final CopyOnWriteHashSet<PersistentMemberID> offlineMembers;
    private final CopyOnWriteHashSet<PersistentMemberID> equalMembers;
    private boolean readyForRecovery;
    protected int recoveredEntryCount;
    private boolean entriesMapIncompatible;
    private RegionMap entries;
    private AtomicBoolean recoveryCompleted;
    protected final AtomicLong numOverflowOnDisk;
    protected final AtomicLong numOverflowBytesOnDisk;
    protected final AtomicLong numEntriesInVM;

    protected AbstractDiskRegion(DiskStoreImpl ds, String name) {
        DiskRegionView drv = ds.getDiskInitFile().takeDiskRegionByName(name);
        if (drv != null) {
            this.ds = drv.getDiskStore();
            this.id = drv.getId();
            this.backup = drv.isBackup();
            this.clearOplogEntryId = drv.getClearOplogEntryId();
            this.clearRVV = drv.getClearRVV();
            this.lruAlgorithm = drv.getLruAlgorithm();
            this.lruAction = drv.getLruAction();
            this.lruLimit = drv.getLruLimit();
            this.concurrencyLevel = drv.getConcurrencyLevel();
            this.initialCapacity = drv.getInitialCapacity();
            this.loadFactor = drv.getLoadFactor();
            this.statisticsEnabled = drv.getStatisticsEnabled();
            this.isBucket = drv.isBucket();
            this.flags = drv.getFlags();
            this.partitionName = drv.getPartitionName();
            this.startingBucketId = drv.getStartingBucketId();
            this.myInitializingId = drv.getMyInitializingID();
            this.myInitializedId = drv.getMyPersistentID();
            this.aboutToDestroy = drv.wasAboutToDestroy();
            this.aboutToDestroyDataStorage = drv.wasAboutToDestroyDataStorage();
            this.onlineMembers = new CopyOnWriteHashSet<PersistentMemberID>(drv.getOnlineMembers());
            this.offlineMembers = new CopyOnWriteHashSet<PersistentMemberID>(drv.getOfflineMembers());
            this.equalMembers = new CopyOnWriteHashSet<PersistentMemberID>(drv.getOfflineAndEqualMembers());
            this.isRecreated = true;
            this.numOverflowOnDisk = ((AbstractDiskRegion)drv).numOverflowOnDisk;
            this.numEntriesInVM = ((AbstractDiskRegion)drv).numEntriesInVM;
            this.numOverflowBytesOnDisk = ((AbstractDiskRegion)drv).numOverflowBytesOnDisk;
            this.entries = drv.getRecoveredEntryMap();
            this.readyForRecovery = drv.isReadyForRecovery();
            this.recoveredEntryCount = drv.getRecoveredEntryCount();
            this.recoveryCompleted = ((AbstractDiskRegion)drv).recoveryCompleted;
            this.versionVector = drv.getRegionVersionVector();
            this.compressorClassName = drv.getCompressorClassName();
            this.compressor = drv.getCompressor();
            this.offHeap = drv.getOffHeap();
            if (drv instanceof PlaceHolderDiskRegion) {
                this.setRVVTrusted(((PlaceHolderDiskRegion)drv).getRVVTrusted());
            }
        } else {
            this.ds = ds;
            this.id = ds.generateRegionId();
            this.flags = EnumSet.noneOf(DiskInitFile.DiskRegionFlag.class);
            this.onlineMembers = new CopyOnWriteHashSet();
            this.offlineMembers = new CopyOnWriteHashSet();
            this.equalMembers = new CopyOnWriteHashSet();
            this.isRecreated = false;
            this.versionVector = new DiskRegionVersionVector(ds.getDiskStoreID());
            this.numOverflowOnDisk = new AtomicLong();
            this.numEntriesInVM = new AtomicLong();
            this.numOverflowBytesOnDisk = new AtomicLong();
        }
    }

    protected AbstractDiskRegion(DiskStoreImpl ds, long id) {
        this.ds = ds;
        this.id = id;
        this.flags = EnumSet.noneOf(DiskInitFile.DiskRegionFlag.class);
        this.onlineMembers = new CopyOnWriteHashSet();
        this.offlineMembers = new CopyOnWriteHashSet();
        this.equalMembers = new CopyOnWriteHashSet();
        this.isRecreated = true;
        this.backup = true;
        this.versionVector = new DiskRegionVersionVector(ds.getDiskStoreID());
        this.numOverflowOnDisk = new AtomicLong();
        this.numEntriesInVM = new AtomicLong();
        this.numOverflowBytesOnDisk = new AtomicLong();
    }

    protected AbstractDiskRegion(DiskRegionView drv) {
        this.ds = drv.getDiskStore();
        this.id = drv.getId();
        this.backup = drv.isBackup();
        this.clearOplogEntryId = drv.getClearOplogEntryId();
        this.clearRVV = drv.getClearRVV();
        this.lruAlgorithm = drv.getLruAlgorithm();
        this.lruAction = drv.getLruAction();
        this.lruLimit = drv.getLruLimit();
        this.concurrencyLevel = drv.getConcurrencyLevel();
        this.initialCapacity = drv.getInitialCapacity();
        this.loadFactor = drv.getLoadFactor();
        this.statisticsEnabled = drv.getStatisticsEnabled();
        this.isBucket = drv.isBucket();
        this.flags = drv.getFlags();
        this.partitionName = drv.getPartitionName();
        this.startingBucketId = drv.getStartingBucketId();
        this.myInitializingId = null;
        this.myInitializedId = drv.getMyPersistentID();
        this.aboutToDestroy = false;
        this.aboutToDestroyDataStorage = false;
        this.onlineMembers = new CopyOnWriteHashSet<PersistentMemberID>(drv.getOnlineMembers());
        this.offlineMembers = new CopyOnWriteHashSet<PersistentMemberID>(drv.getOfflineMembers());
        this.equalMembers = new CopyOnWriteHashSet<PersistentMemberID>(drv.getOfflineAndEqualMembers());
        this.isRecreated = true;
        this.numOverflowOnDisk = new AtomicLong();
        this.numEntriesInVM = new AtomicLong();
        this.numOverflowBytesOnDisk = new AtomicLong();
        this.entries = drv.getRecoveredEntryMap();
        this.readyForRecovery = drv.isReadyForRecovery();
        this.recoveredEntryCount = 0;
        this.recoveryCompleted = ((AbstractDiskRegion)drv).recoveryCompleted;
        this.versionVector = drv.getRegionVersionVector();
        this.compressorClassName = drv.getCompressorClassName();
        this.compressor = drv.getCompressor();
        this.offHeap = drv.getOffHeap();
    }

    @Override
    public abstract String getName();

    @Override
    public DiskStoreImpl getDiskStore() {
        return this.ds;
    }

    abstract void beginDestroyRegion(LocalRegion var1);

    public void resetRVV() {
        this.versionVector = new DiskRegionVersionVector(this.ds.getDiskStoreID());
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public long getClearOplogEntryId() {
        return this.clearOplogEntryId;
    }

    @Override
    public void setClearOplogEntryId(long v) {
        this.clearOplogEntryId = v;
    }

    @Override
    public RegionVersionVector getClearRVV() {
        return this.clearRVV;
    }

    @Override
    public void setClearRVV(RegionVersionVector rvv) {
        this.clearRVV = rvv;
    }

    @Override
    public void setConfig(byte lruAlgorithm, byte lruAction, int lruLimit, int concurrencyLevel, int initialCapacity, float loadFactor, boolean statisticsEnabled, boolean isBucket, EnumSet<DiskInitFile.DiskRegionFlag> flags, String partitionName, int startingBucketId, String compressorClassName, boolean offHeap) {
        this.lruAlgorithm = lruAlgorithm;
        this.lruAction = lruAction;
        this.lruLimit = lruLimit;
        this.concurrencyLevel = concurrencyLevel;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.statisticsEnabled = statisticsEnabled;
        this.isBucket = isBucket;
        if (flags != null && flags != this.flags) {
            this.flags.clear();
            this.flags.addAll(flags);
        }
        this.partitionName = partitionName;
        this.startingBucketId = startingBucketId;
        this.compressorClassName = compressorClassName;
        this.offHeap = offHeap;
        if (!this.ds.isOffline()) {
            this.createCompressorFromClassName();
        }
    }

    public void createCompressorFromClassName() {
        if (Strings.isNullOrEmpty((String)this.compressorClassName)) {
            this.compressor = null;
        } else {
            try {
                Class<?> compressorClass = ClassPathLoader.getLatest().forName(this.compressorClassName);
                this.compressor = (Compressor)compressorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Unknown Compressor %s found in disk initialization file.", this.compressorClassName), e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(String.format("Unknown Compressor %s found in disk initialization file.", this.compressorClassName), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unknown Compressor %s found in disk initialization file.", this.compressorClassName), e);
            }
        }
    }

    @Override
    public EvictionAttributes getEvictionAttributes() {
        return new EvictionAttributesImpl().setAlgorithm(this.getActualLruAlgorithm()).setAction(this.getActualLruAction()).setMaximum(this.getLruLimit());
    }

    @Override
    public byte getLruAlgorithm() {
        return this.lruAlgorithm;
    }

    public EvictionAlgorithm getActualLruAlgorithm() {
        return EvictionAlgorithm.parseValue(this.getLruAlgorithm());
    }

    @Override
    public byte getLruAction() {
        return this.lruAction;
    }

    public EvictionAction getActualLruAction() {
        return EvictionAction.parseValue(this.getLruAction());
    }

    @Override
    public int getLruLimit() {
        return this.lruLimit;
    }

    @Override
    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    @Override
    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public float getLoadFactor() {
        return this.loadFactor;
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public boolean isBucket() {
        return this.isBucket;
    }

    @Override
    public EnumSet<DiskInitFile.DiskRegionFlag> getFlags() {
        return this.flags;
    }

    @Override
    public String getPartitionName() {
        return this.partitionName;
    }

    @Override
    public int getStartingBucketId() {
        return this.startingBucketId;
    }

    public String getPrName() {
        assert (this.isBucket());
        String bn = PartitionedRegionHelper.getBucketName(this.getName());
        return PartitionedRegionHelper.getPRPath(bn);
    }

    @Override
    public PersistentMemberID addMyInitializingPMID(PersistentMemberID pmid) {
        PersistentMemberID result = this.myInitializingId;
        this.myInitializingId = pmid;
        if (result != null) {
            this.myInitializedId = result;
        }
        return result;
    }

    @Override
    public void markInitialized() {
        assert (this.myInitializingId != null);
        this.myInitializedId = this.myInitializingId;
        this.myInitializingId = null;
    }

    @Override
    public boolean addOnlineMember(PersistentMemberID pmid) {
        return this.onlineMembers.add(pmid);
    }

    @Override
    public boolean addOfflineMember(PersistentMemberID pmid) {
        return this.offlineMembers.add(pmid);
    }

    @Override
    public boolean addOfflineAndEqualMember(PersistentMemberID pmid) {
        return this.equalMembers.add(pmid);
    }

    @Override
    public boolean rmOnlineMember(PersistentMemberID pmid) {
        return this.onlineMembers.remove(pmid);
    }

    @Override
    public boolean rmOfflineMember(PersistentMemberID pmid) {
        return this.offlineMembers.remove(pmid);
    }

    @Override
    public boolean rmEqualMember(PersistentMemberID pmid) {
        return this.equalMembers.remove(pmid);
    }

    @Override
    public void markBeginDestroyRegion() {
        this.aboutToDestroy = true;
    }

    @Override
    public void markBeginDestroyDataStorage() {
        this.aboutToDestroyDataStorage = true;
    }

    @Override
    public void markEndDestroyRegion() {
        this.onlineMembers.clear();
        this.offlineMembers.clear();
        this.equalMembers.clear();
        this.myInitializedId = null;
        this.myInitializingId = null;
        this.aboutToDestroy = false;
        this.isRecreated = false;
    }

    @Override
    public void markEndDestroyDataStorage() {
        this.myInitializedId = null;
        this.myInitializingId = null;
        this.aboutToDestroyDataStorage = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentMemberID getMyInitializingID() {
        DiskInitFile dif = this.ds.getDiskInitFile();
        if (dif == null) {
            return this.myInitializingId;
        }
        DiskInitFile diskInitFile = dif;
        synchronized (diskInitFile) {
            return this.myInitializingId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentMemberID getMyPersistentID() {
        DiskInitFile dif = this.ds.getDiskInitFile();
        if (dif == null) {
            return this.myInitializedId;
        }
        DiskInitFile diskInitFile = dif;
        synchronized (diskInitFile) {
            return this.myInitializedId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PersistentMemberID> getOnlineMembers() {
        DiskInitFile dif = this.ds.getDiskInitFile();
        if (dif == null) {
            return this.onlineMembers.getSnapshot();
        }
        DiskInitFile diskInitFile = dif;
        synchronized (diskInitFile) {
            return this.onlineMembers.getSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PersistentMemberID> getOfflineMembers() {
        DiskInitFile dif = this.ds.getDiskInitFile();
        if (dif == null) {
            return this.offlineMembers.getSnapshot();
        }
        DiskInitFile diskInitFile = dif;
        synchronized (diskInitFile) {
            return this.offlineMembers.getSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PersistentMemberID> getOfflineAndEqualMembers() {
        DiskInitFile dif = this.ds.getDiskInitFile();
        if (dif == null) {
            return this.equalMembers.getSnapshot();
        }
        DiskInitFile diskInitFile = dif;
        synchronized (diskInitFile) {
            return this.equalMembers.getSnapshot();
        }
    }

    @Override
    public Set<PersistentMemberPattern> getRevokedMembers() {
        DiskInitFile dif = this.ds.getDiskInitFile();
        return this.ds.getRevokedMembers();
    }

    @Override
    public void memberOffline(PersistentMemberID persistentID) {
        this.ds.memberOffline(this, persistentID);
        if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - member offline {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)persistentID);
        }
    }

    @Override
    public void memberOfflineAndEqual(PersistentMemberID persistentID) {
        this.ds.memberOfflineAndEqual(this, persistentID);
        if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - member offline and equal {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)persistentID);
        }
    }

    @Override
    public void memberOnline(PersistentMemberID persistentID) {
        this.ds.memberOnline(this, persistentID);
        if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - member online {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)persistentID);
        }
    }

    @Override
    public void memberRemoved(PersistentMemberID persistentID) {
        this.ds.memberRemoved(this, persistentID);
        if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - member removed {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)persistentID);
        }
    }

    @Override
    public void memberRevoked(PersistentMemberPattern revokedPattern) {
        this.ds.memberRevoked(revokedPattern);
        if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - member revoked {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)revokedPattern);
        }
    }

    @Override
    public void setInitializing(PersistentMemberID newId) {
        this.ds.setInitializing(this, newId);
        if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - initializing local id: {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)this.getMyInitializingID());
        }
    }

    @Override
    public void setInitialized() {
        this.ds.setInitialized(this);
        if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - initialized local id: {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)this.getMyPersistentID());
        }
    }

    @Override
    public PersistentMemberID generatePersistentID() {
        return this.ds.generatePersistentID();
    }

    @Override
    public boolean isRecreated() {
        return this.isRecreated;
    }

    @Override
    public boolean hasConfigChanged() {
        return this.configChanged;
    }

    @Override
    public void setConfigChanged(boolean v) {
        this.configChanged = v;
    }

    @Override
    public void endDestroy(LocalRegion region) {
        if (this.isReadyForRecovery()) {
            this.ds.updateDiskRegion(this);
            this.entriesMapIncompatible = false;
            if (this.entries != null) {
                Map.Entry<Object, Object> me;
                RegionEntry oldRe;
                ConcurrentMapWithReusableEntries<Object, Object> other = this.entries.getCustomEntryConcurrentHashMap();
                Iterator<Map.Entry<Object, Object>> iterator = other.entrySetWithReusableEntries().iterator();
                while (iterator.hasNext() && (oldRe = (RegionEntry)(me = iterator.next()).getValue()) instanceof OffHeapRegionEntry) {
                    ((OffHeapRegionEntry)oldRe).release();
                }
            }
            this.entries = null;
            this.readyForRecovery = false;
        }
        if (this.aboutToDestroyDataStorage) {
            this.ds.endDestroyDataStorage(region, (DiskRegion)this);
            if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
                logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - endDestroyDataStorage: {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)this.getMyPersistentID());
            }
        } else {
            this.ds.endDestroyRegion(region, (DiskRegion)this);
            if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
                logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - endDestroy: {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)this.getMyPersistentID());
            }
        }
    }

    @Override
    public void beginDestroy(LocalRegion region) {
        this.beginDestroyRegion(region);
        if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - beginDestroy: {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)this.getMyPersistentID());
        }
        if (this.myInitializedId == null) {
            this.endDestroy(region);
        }
    }

    @Override
    public void beginDestroyDataStorage() {
        this.ds.beginDestroyDataStorage((DiskRegion)this);
        if (logger.isTraceEnabled(LogMarker.PERSIST_VERBOSE)) {
            logger.trace(LogMarker.PERSIST_VERBOSE, "PersistentView {} - {} - beginDestroyDataStorage: {}", (Object)this.getDiskStoreID().abbrev(), (Object)this.getName(), (Object)this.getMyPersistentID());
        }
    }

    public void createDataStorage() {
    }

    @Override
    public boolean wasAboutToDestroy() {
        return this.aboutToDestroy;
    }

    @Override
    public boolean wasAboutToDestroyDataStorage() {
        return this.aboutToDestroyDataStorage;
    }

    public void setEntriesMapIncompatible(boolean v) {
        this.entriesMapIncompatible = v;
    }

    @Override
    public boolean isEntriesMapIncompatible() {
        return this.entriesMapIncompatible;
    }

    public RegionMap useExistingRegionMap(LocalRegion lr) {
        RegionMap result = null;
        if (!this.entriesMapIncompatible) {
            result = this.entries;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRecoveryCompletion() {
        boolean interrupted = Thread.interrupted();
        AtomicBoolean atomicBoolean = this.recoveryCompleted;
        synchronized (atomicBoolean) {
            try {
                while (!this.recoveryCompleted.get()) {
                    try {
                        this.recoveryCompleted.wait();
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public void copyExistingRegionMap(LocalRegion lr) {
        this.waitForRecoveryCompletion();
        if (this.entriesMapIncompatible) {
            this.numEntriesInVM.set(0L);
            lr.initializeStats(this.getNumEntriesInVM(), this.getNumOverflowOnDisk(), this.getNumOverflowBytesOnDisk());
            lr.copyRecoveredEntries(this.entries);
        } else {
            this.entries.changeOwner(lr);
            lr.initializeStats(this.getNumEntriesInVM(), this.getNumOverflowOnDisk(), this.getNumOverflowBytesOnDisk());
            lr.copyRecoveredEntries(null);
        }
        this.entries = null;
    }

    public void setRecoveredEntryMap(RegionMap rm) {
        this.recoveryCompleted = new AtomicBoolean();
        this.entries = rm;
    }

    @Override
    public RegionMap getRecoveredEntryMap() {
        return this.entries;
    }

    public void releaseRecoveryData() {
        this.readyForRecovery = false;
    }

    @Override
    public boolean isReadyForRecovery() {
        return this.readyForRecovery;
    }

    @Override
    public void prepareForRecovery() {
        this.readyForRecovery = true;
    }

    @Override
    public int getRecoveredEntryCount() {
        return this.recoveredEntryCount;
    }

    @Override
    public void incRecoveredEntryCount() {
        ++this.recoveredEntryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initRecoveredEntryCount() {
        if (this.recoveryCompleted != null) {
            AtomicBoolean atomicBoolean = this.recoveryCompleted;
            synchronized (atomicBoolean) {
                this.recoveryCompleted.set(true);
                this.recoveryCompleted.notifyAll();
            }
        }
    }

    @Override
    public long getNumOverflowOnDisk() {
        return this.numOverflowOnDisk.get();
    }

    @Override
    public void incNumOverflowOnDisk(long delta) {
        this.numOverflowOnDisk.addAndGet(delta);
    }

    @Override
    public long getNumOverflowBytesOnDisk() {
        return this.numOverflowBytesOnDisk.get();
    }

    @Override
    public void incNumOverflowBytesOnDisk(long delta) {
        this.numOverflowBytesOnDisk.addAndGet(delta);
    }

    @Override
    public long getNumEntriesInVM() {
        return this.numEntriesInVM.get();
    }

    @Override
    public void incNumEntriesInVM(long delta) {
        this.numEntriesInVM.addAndGet(delta);
    }

    @Override
    public boolean isBackup() {
        return this.backup;
    }

    protected void setBackup(boolean v) {
        this.backup = v;
    }

    public void dump(PrintStream printStream) {
        String name = this.getName();
        if (this.isBucket() && !logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            name = this.getPrName();
        }
        String msg = name + ": -lru=" + this.getEvictionAttributes().getAlgorithm();
        if (!this.getEvictionAttributes().getAlgorithm().isNone()) {
            msg = msg + " -lruAction=" + this.getEvictionAttributes().getAction();
            if (!this.getEvictionAttributes().getAlgorithm().isLRUHeap()) {
                msg = msg + " -lruLimit=" + this.getEvictionAttributes().getMaximum();
            }
        }
        msg = msg + " -concurrencyLevel=" + this.getConcurrencyLevel() + " -initialCapacity=" + this.getInitialCapacity() + " -loadFactor=" + this.getLoadFactor() + " -offHeap=" + this.getOffHeap() + " -compressor=" + (this.getCompressorClassName() == null ? "none" : this.getCompressorClassName()) + " -statisticsEnabled=" + this.getStatisticsEnabled();
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            msg = msg + " drId=" + this.getId() + " isBucket=" + this.isBucket() + " clearEntryId=" + this.getClearOplogEntryId() + " MyInitializingID=<" + this.getMyInitializingID() + "> MyPersistentID=<" + this.getMyPersistentID() + "> onlineMembers=" + this.getOnlineMembers() + " offlineMembers=" + this.getOfflineMembers() + " equalsMembers=" + this.getOfflineAndEqualMembers();
        }
        printStream.println(msg);
    }

    public String dump2() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String name = this.getName();
        if (this.isBucket() && logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            name = this.getPrName();
        }
        String msg = name + ": -lru=" + this.getEvictionAttributes().getAlgorithm();
        sb.append(name);
        sb.append(lineSeparator);
        sb.append("lru=" + this.getEvictionAttributes().getAlgorithm());
        sb.append(lineSeparator);
        if (!this.getEvictionAttributes().getAlgorithm().isNone()) {
            sb.append("lruAction=" + this.getEvictionAttributes().getAction());
            sb.append(lineSeparator);
            if (!this.getEvictionAttributes().getAlgorithm().isLRUHeap()) {
                sb.append("lruAction=" + this.getEvictionAttributes().getAction());
                sb.append(lineSeparator);
            }
        }
        sb.append("-concurrencyLevel=" + this.getConcurrencyLevel());
        sb.append(lineSeparator);
        sb.append("-initialCapacity=" + this.getInitialCapacity());
        sb.append(lineSeparator);
        sb.append("-loadFactor=" + this.getLoadFactor());
        sb.append(lineSeparator);
        sb.append("-offHeap=" + this.getOffHeap());
        sb.append(lineSeparator);
        sb.append("-compressor=" + (this.getCompressorClassName() == null ? "none" : this.getCompressorClassName()));
        sb.append(lineSeparator);
        sb.append("-statisticsEnabled=" + this.getStatisticsEnabled());
        sb.append(lineSeparator);
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY_VERBOSE)) {
            sb.append("drId=" + this.getId());
            sb.append(lineSeparator);
            sb.append("isBucket=" + this.isBucket());
            sb.append(lineSeparator);
            sb.append("clearEntryId=" + this.getClearOplogEntryId());
            sb.append(lineSeparator);
            sb.append("MyInitializingID=<" + this.getMyInitializingID() + ">");
            sb.append(lineSeparator);
            sb.append("MyPersistentID=<" + this.getMyPersistentID() + ">");
            sb.append(lineSeparator);
            sb.append("onlineMembers=" + this.getOnlineMembers());
            sb.append(lineSeparator);
            sb.append("offlineMembers=" + this.getOfflineMembers());
            sb.append(lineSeparator);
            sb.append("equalsMembers=" + this.getOfflineAndEqualMembers());
            sb.append(lineSeparator);
            sb.append("flags=").append(this.getFlags());
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    public void dumpMetadata() {
        String name = this.getName();
        StringBuilder msg = new StringBuilder(name);
        this.dumpCommonAttributes(msg);
        this.dumpPersistentView(msg);
        System.out.println(msg);
    }

    public void dumpPersistentView(StringBuilder msg) {
        msg.append("\n\tMyInitializingID=<").append(this.getMyInitializingID()).append(">");
        msg.append("\n\tMyPersistentID=<").append(this.getMyPersistentID()).append(">");
        msg.append("\n\tonlineMembers:");
        for (PersistentMemberID id : this.getOnlineMembers()) {
            msg.append("\n\t\t").append(id);
        }
        msg.append("\n\tofflineMembers:");
        for (PersistentMemberID id : this.getOfflineMembers()) {
            msg.append("\n\t\t").append(id);
        }
        msg.append("\n\tequalsMembers:");
        for (PersistentMemberID id : this.getOfflineAndEqualMembers()) {
            msg.append("\n\t\t").append(id);
        }
    }

    public void dumpCommonAttributes(StringBuilder msg) {
        msg.append("\n\tlru=").append(this.getEvictionAttributes().getAlgorithm());
        if (!this.getEvictionAttributes().getAlgorithm().isNone()) {
            msg.append("\n\tlruAction=").append(this.getEvictionAttributes().getAction());
            if (!this.getEvictionAttributes().getAlgorithm().isLRUHeap()) {
                msg.append("\n\tlruLimit=").append(this.getEvictionAttributes().getMaximum());
            }
        }
        msg.append("\n\tconcurrencyLevel=").append(this.getConcurrencyLevel());
        msg.append("\n\tinitialCapacity=").append(this.getInitialCapacity());
        msg.append("\n\tloadFactor=").append(this.getLoadFactor());
        msg.append("\n\toffHeap=").append(this.getOffHeap());
        msg.append("\n\tstatisticsEnabled=").append(this.getStatisticsEnabled());
        msg.append("\n\tdrId=").append(this.getId());
        msg.append("\n\tisBucket=").append(this.isBucket());
        msg.append("\n\tclearEntryId=").append(this.getClearOplogEntryId());
        msg.append("\n\tflags=").append(this.getFlags());
    }

    @Override
    public Object getRaw(DiskId id) {
        this.acquireReadLock();
        try {
            Object object = this.getDiskStore().getRaw(this, id);
            return object;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public RegionVersionVector getRegionVersionVector() {
        return this.versionVector;
    }

    public long getVersionForMember(VersionSource member) {
        return this.versionVector.getVersionForMember(member);
    }

    public void recordRecoveredGCVersion(VersionSource member, long gcVersion) {
        this.versionVector.recordGCVersion(member, gcVersion);
    }

    public void recordRecoveredVersionHolder(VersionSource member, RegionVersionHolder versionHolder, boolean latestOplog) {
        this.versionVector.initRecoveredVersion(member, versionHolder, latestOplog);
    }

    public void recordRecoveredVersionTag(VersionTag tag) {
        this.versionVector.recordVersion(tag.getMemberID(), tag.getRegionVersion());
    }

    public void setRVVTrusted(boolean trusted) {
        this.rvvTrusted = trusted;
    }

    public boolean getRVVTrusted() {
        return this.rvvTrusted;
    }

    public PersistentOplogSet getOplogSet() {
        return this.getDiskStore().getPersistentOplogSet(this);
    }

    @Override
    public String getCompressorClassName() {
        return this.compressorClassName;
    }

    @Override
    public Compressor getCompressor() {
        return this.compressor;
    }

    @Override
    public boolean getOffHeap() {
        return this.offHeap;
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        return this.ds.getCache().getCachePerfStats();
    }

    @Override
    public void oplogRecovered(long oplogId) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getName();
    }

    @Override
    public void incRecentlyUsed() {
        this.entries.incRecentlyUsed();
    }

    @Override
    public StatisticsFactory getStatisticsFactory() {
        return this.ds.getStatisticsFactory();
    }

    @Override
    public String getNameForStats() {
        if (this.isBucket()) {
            return this.getPrName();
        }
        return this.getName();
    }

    @Override
    public InternalCache getCache() {
        return this.getDiskStore().getCache();
    }
}

