/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VersionedThinDiskRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedThinDiskRegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedThinDiskRegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedThinDiskRegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedThinDiskRegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedThinDiskRegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedThinDiskRegionEntryHeapUUIDKey;

public abstract class VersionedThinDiskRegionEntryHeap
extends VersionedThinDiskRegionEntry {
    @Immutable
    private static final VersionedThinDiskRegionEntryHeapFactory factory = new VersionedThinDiskRegionEntryHeapFactory();

    public VersionedThinDiskRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinDiskRegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinDiskRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinDiskRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinDiskRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinDiskRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinDiskRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinDiskRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedThinDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

