/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.DistributedRegionFunctionStreamingMessage;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalResultSender;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DistributedRegionFunctionResultSender
implements InternalResultSender {
    private static final Logger logger = LogService.getLogger();
    DistributedRegionFunctionStreamingMessage msg = null;
    private final DistributionManager dm;
    private ResultCollector rc;
    private boolean isLocal;
    private ServerToClientFunctionResultSender sender;
    private final Function functionObject;
    private boolean enableOrderedResultStreming;
    private boolean localLastResultReceived = false;

    public DistributedRegionFunctionResultSender(DistributionManager dm, DistributedRegionFunctionStreamingMessage msg, Function function) {
        this.msg = msg;
        this.dm = dm;
        this.functionObject = function;
    }

    public DistributedRegionFunctionResultSender(DistributionManager dm, ResultCollector rc, Function function, ServerToClientFunctionResultSender sender) {
        this.dm = dm;
        this.isLocal = true;
        this.rc = rc;
        this.functionObject = function;
        this.sender = sender;
    }

    @Override
    public void lastResult(Object oneResult) {
        if (!this.functionObject.hasResult()) {
            throw new IllegalStateException(String.format("Cannot %s result as the Function#hasResult() is false", "send"));
        }
        if (this.localLastResultReceived) {
            return;
        }
        this.localLastResultReceived = true;
        if (this.sender != null) {
            this.sender.lastResult(oneResult);
            if (this.rc != null) {
                this.rc.endResults();
            }
        } else {
            if (this.isLocal) {
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                this.rc.endResults();
                FunctionStatsManager.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReceived();
            } else {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, true, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            }
            FunctionStatsManager.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    public void lastResult(Object oneResult, DistributedMember memberID) {
        if (!this.functionObject.hasResult()) {
            throw new IllegalStateException(String.format("Cannot %s result as the Function#hasResult() is false", "send"));
        }
        this.localLastResultReceived = true;
        if (this.sender != null) {
            this.sender.lastResult(oneResult, memberID);
            if (this.rc != null) {
                this.rc.endResults();
            }
        } else {
            if (this.isLocal) {
                this.rc.addResult(memberID, oneResult);
                this.rc.endResults();
            } else {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, true, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            }
            if (this.dm == null) {
                FunctionStatsManager.getFunctionStats(this.functionObject.getId()).incResultsReceived();
            } else {
                FunctionStatsManager.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReceived();
            }
        }
    }

    @Override
    public synchronized void sendResult(Object oneResult) {
        if (!this.functionObject.hasResult()) {
            throw new IllegalStateException(String.format("Cannot %s result as the Function#hasResult() is false", "send"));
        }
        if (this.sender != null) {
            this.sender.sendResult(oneResult);
        } else {
            if (this.isLocal) {
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                FunctionStatsManager.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReceived();
            } else {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, false, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            }
            FunctionStatsManager.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    public synchronized void sendResult(Object oneResult, DistributedMember memberID) {
        if (!this.functionObject.hasResult()) {
            throw new IllegalStateException(String.format("Cannot %s result as the Function#hasResult() is false", "send"));
        }
        if (this.sender != null) {
            this.sender.sendResult(oneResult, memberID);
        } else {
            if (this.isLocal) {
                this.rc.addResult(memberID, oneResult);
                if (this.dm == null) {
                    FunctionStatsManager.getFunctionStats(this.functionObject.getId()).incResultsReceived();
                } else {
                    FunctionStatsManager.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReceived();
                }
            } else {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, false, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            }
            if (this.dm == null) {
                FunctionStatsManager.getFunctionStats(this.functionObject.getId()).incResultsReturned();
            } else {
                FunctionStatsManager.getFunctionStats(this.functionObject.getId(), this.dm.getSystem()).incResultsReturned();
            }
        }
    }

    @Override
    public void sendException(Throwable exception) {
        InternalFunctionException iFunxtionException = new InternalFunctionException(exception);
        this.lastResult(iFunxtionException);
        this.localLastResultReceived = true;
    }

    @Override
    public void setException(Throwable exception) {
        if (this.sender != null) {
            this.sender.setException(exception);
        } else {
            ((LocalResultCollector)this.rc).setException(exception);
            logger.info("Unexpected exception during function execution on local node Distributed Region", exception);
        }
        this.rc.endResults();
        this.localLastResultReceived = true;
    }

    @Override
    public void enableOrderedResultStreming(boolean enable) {
        this.enableOrderedResultStreming = enable;
    }

    @Override
    public boolean isLocallyExecuted() {
        return this.msg == null;
    }

    @Override
    public boolean isLastResultReceived() {
        return this.localLastResultReceived;
    }
}

