/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class InterestEventMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private InterestRegistrationEvent event;

    public InterestEventMessage() {
    }

    private InterestEventMessage(Set recipients, int regionId, int processorId, InterestRegistrationEvent event, ReplyProcessor21 processor) {
        super(recipients, regionId, processor);
        this.event = event;
    }

    @Override
    public int getProcessorType() {
        return 73;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) throws ForceReattemptException {
        PartitionedRegionDataStore ds;
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "InterestEventMessage operateOnPartitionedRegion: {}", (Object)r.getFullPath());
        }
        if ((ds = r.getDataStore()) != null) {
            try {
                ds.handleInterestEvent(this.event);
                r.getPrStats().endPartitionMessagesProcessing(startTime);
                InterestEventReplyMessage.send(this.getSender(), this.getProcessorId(), dm);
            }
            catch (Exception e) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(new ForceReattemptException("Caught exception during interest registration processing:", e)), r, startTime);
                return false;
            }
        } else {
            throw new InternalError("InterestEvent message was sent to a member with no storage.");
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; event=").append(this.event);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.event = (InterestRegistrationEvent)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.event, out);
    }

    public static InterestEventResponse send(Set recipients, PartitionedRegion region, InterestRegistrationEvent event) throws ForceReattemptException {
        InterestEventResponse response = new InterestEventResponse(region.getSystem(), recipients);
        InterestEventMessage m = new InterestEventMessage(recipients, region.getPRId(), response.getProcessorId(), event, response);
        m.setTransactionDistributed(region.getCache().getTxManager().isDistributed());
        Set<InternalDistributedMember> failures = region.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException("Failed sending <" + m + "> to " + failures);
        }
        return response;
    }

    public int getDSFID() {
        return -47;
    }

    public static class InterestEventResponse
    extends PartitionMessage.PartitionResponse {
        public InterestEventResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients);
        }

        public void waitForResponse() throws ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException e) {
                logger.debug("InterestEventResponse got ForceReattemptException; rethrowing {}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
            catch (CacheException e) {
                String msg = "InterestEventResponse got remote CacheException, throwing ForceReattemptException";
                logger.debug("InterestEventResponse got remote CacheException, throwing ForceReattemptException", (Throwable)e);
                throw new ForceReattemptException("InterestEventResponse got remote CacheException, throwing ForceReattemptException", e);
            }
        }
    }

    public static class InterestEventReplyMessage
    extends HighPriorityDistributionMessage {
        private int processorId;

        public InterestEventReplyMessage() {
        }

        private InterestEventReplyMessage(int processorId) {
            this.processorId = processorId;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistributionManager dm) throws ForceReattemptException {
            InterestEventReplyMessage m = new InterestEventReplyMessage(processorId);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "InterestEventReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            try {
                ReplyProcessor21 processor = ReplyProcessor21.getProcessor(this.processorId);
                if (processor == null) {
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "InterestEventReplyMessage processor not found");
                    }
                    return;
                }
                processor.process(this);
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace("{} processed {}", (Object)processor, (Object)this);
                }
            }
            finally {
                dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
            }
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer().append("InterestEventReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }

        public int getDSFID() {
            return -46;
        }
    }
}

