/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.config;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.XSDRootElement;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.config.NameSpaceFilter;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.management.internal.util.ClasspathScanLoadHelper;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JAXBService {
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;
    private final NameSpaceFilter nameSpaceFilter;

    public JAXBService(Class<?> ... xsdRootClasses) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])xsdRootClasses);
            this.marshaller = jaxbContext.createMarshaller();
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.marshaller.setProperty("jaxb.fragment", (Object)true);
            String schemas = Arrays.stream(xsdRootClasses).map(c -> {
                XSDRootElement element = c.getAnnotation(XSDRootElement.class);
                if (element != null && StringUtils.isNotEmpty((CharSequence)element.namespace()) && StringUtils.isNotEmpty((CharSequence)element.schemaLocation())) {
                    return element.namespace() + " " + element.schemaLocation();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.joining(" "));
            this.marshaller.setProperty("jaxb.schemaLocation", (Object)schemas);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            this.nameSpaceFilter = new NameSpaceFilter();
            this.nameSpaceFilter.setParent(reader);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static JAXBService create(Class<?> ... xsdClasses) {
        if (xsdClasses != null && xsdClasses.length > 0) {
            return new JAXBService(xsdClasses);
        }
        return new JAXBService(JAXBService.scanForClasses().toArray(new Class[0]));
    }

    public static JAXBService createWithValidation(Class<?> ... xsdClasses) {
        JAXBService jaxbService = JAXBService.create(xsdClasses);
        jaxbService.validateWithLocalCacheXSD();
        return jaxbService;
    }

    static Set<String> getPackagesToScan() {
        Set<String> packages = new HashSet<String>();
        String sysProperty = SystemPropertyHelper.getProperty("packagesToScan");
        if (sysProperty != null) {
            packages = Arrays.stream(sysProperty.split(",")).collect(Collectors.toSet());
        } else {
            packages.add("*");
        }
        return packages;
    }

    private static Set<Class<?>> scanForClasses() {
        Set<String> packages = JAXBService.getPackagesToScan();
        try (ClasspathScanLoadHelper scanner = new ClasspathScanLoadHelper(packages);){
            Set<Class<?>> set = scanner.scanClasspathForAnnotation(XSDRootElement.class, packages.toArray(new String[0]));
            return set;
        }
    }

    private void validateWith(URL url) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = factory.newSchema(url);
            this.marshaller.setSchema(schema);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void validateWithLocalCacheXSD() {
        URL local_cache_xsd = ClassPathLoader.getLatest().getResource("META-INF/schemas/geode.apache.org/schema/cache/cache-1.0.xsd");
        this.validateWith(local_cache_xsd);
    }

    public String marshall(Object object) {
        StringWriter sw = new StringWriter();
        try {
            sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            this.marshaller.marshal(object, (Writer)sw);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return sw.toString();
    }

    public <T> T unMarshall(String xml) {
        try {
            SAXSource source = new SAXSource(this.nameSpaceFilter, new InputSource(new StringReader(xml)));
            return (T)this.unmarshaller.unmarshal((Source)source);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T> T unMarshall(String xml, Class<T> klass) {
        try {
            SAXSource source = new SAXSource(this.nameSpaceFilter, new InputSource(new StringReader(xml)));
            return (T)this.unmarshaller.unmarshal((Source)source, klass).getValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

